<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_mailchimp_form_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_mailchimp_form_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_MailChimp_Form_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_mailchimp_form_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_MailChimp_Form_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_mailchimp_form_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_mailchimp_form_extra_options', array(), $this ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/mailchimp-form' );
			$this->set_base( 'qi_addons_for_elementor_premium_mailchimp_form' );
			$this->set_name( esc_html__( 'MailChimp Form', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds MailChimp Form element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Form Style', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/mailchimp-form/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#mailchimp_form' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'standard',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'hide_indicates_required',
					'title'         => esc_html__( 'Hide Indicates Required', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'code',
					'name'       => 'html',
					'title'      => esc_html__( 'HTML', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'label_typography',
					'title'      => esc_html__( 'Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form label',
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_color',
					'title'      => esc_html__( 'Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_typography',
					'title'      => esc_html__( 'Input Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]), {{WRAPPER}} .qodef-qi-mailchimp-form textarea, {{WRAPPER}} .qodef-qi-mailchimp-form select',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_color',
					'title'      => esc_html__( 'Input Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit])'              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea'                              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select'                                => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit])::placeholder' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea::placeholder'                 => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_background_color',
					'title'      => esc_html__( 'Input Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit])' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea'                 => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select'                   => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'input_border',
					'title'      => esc_html__( 'Input Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]),{{WRAPPER}} .qodef-qi-mailchimp-form textarea, {{WRAPPER}} .qodef-qi-mailchimp-form select',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_focus_typography',
					'title'      => esc_html__( 'Input Focus Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]):focus, {{WRAPPER}} .qodef-qi-mailchimp-form textarea:focus, {{WRAPPER}} .qodef-qi-mailchimp-form select:focus',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_focus_color',
					'title'      => esc_html__( 'Input Focus Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]):focus'              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea:focus'                              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select:focus'                                => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]):focus::placeholder' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea:focus::placeholder'                 => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_focus_background_color',
					'title'      => esc_html__( 'Input Focus Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]):focus' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea:focus'                 => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select:focus'                   => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'input_focus_border',
					'title'      => esc_html__( 'Input Focus Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]):focus,{{WRAPPER}} .qodef-qi-mailchimp-form textarea:focus, {{WRAPPER}} .qodef-qi-mailchimp-form select:focus',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_border_radius',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_padding',
					'title'      => esc_html__( 'Input Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea'                 => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select'                   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_border_radius',
					'title'      => esc_html__( 'Input Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea'                 => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select'                   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_group_typography_strong',
					'title'      => esc_html__( 'Radio and Checkbox Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form .input-group strong',
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_group_color_strong',
					'title'      => esc_html__( 'Radio and Checkbox Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group strong' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'input_group_size_strong',
					'title'      => esc_html__( 'Radio and Checkbox Title Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group strong' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_group_typography',
					'title'      => esc_html__( 'Radio and Checkbox Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form .input-group label',
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_group_color',
					'title'      => esc_html__( 'Radio and Checkbox Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'input_group_size',
					'title'      => esc_html__( 'Radio and Checkbox Label Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group label' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'input_group_space',
					'title'      => esc_html__( 'Radio and Checkbox Space Between', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group li:not(:first-child)' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Radio and Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'button_typography',
					'title'      => esc_html__( 'Button Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]',
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_button_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_button_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_color',
					'title'      => esc_html__( 'Button Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_background_color',
					'title'      => esc_html__( 'Button Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_border_color',
					'title'      => esc_html__( 'Button Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_button_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_button_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_color',
					'title'      => esc_html__( 'Button Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]:hover' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_background_color',
					'title'      => esc_html__( 'Button Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]:hover' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_border_color',
					'title'      => esc_html__( 'Button Hover Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]:hover' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_button_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_button_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_hover',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'button_border_style',
					'title'      => esc_html__( 'Button Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'border_style' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'border-style: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_border_width',
					'title'      => esc_html__( 'Button Border Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_border_radius',
					'title'      => esc_html__( 'Button Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'label_margin',
					'title'      => esc_html__( 'Label Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .mc-field-group > label, {{WRAPPER}} .qodef-qi-mailchimp-form .input-group strong' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'radio_and_checkbox_group_margin',
					'title'      => esc_html__( 'Radio and Checkbox Group Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'radio_and_checkbox_label_margin',
					'title'      => esc_html__( 'Radio and Checkbox Label Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form .input-group ul li label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_margin',
					'title'      => esc_html__( 'Input Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input:not([type=submit]):not([type=checkbox]):not([type=radio])' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form textarea'                 => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-mailchimp-form select'                   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_margin',
					'title'      => esc_html__( 'Button Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_padding',
					'title'      => esc_html__( 'Button Padding', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-mailchimp-form input[type=submit]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'group'      => esc_html__( 'Global Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/mailchimp-form', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-mailchimp-form';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['alignment'] ) ? 'qodef-alignment--' . $atts['alignment'] : '';
			$holder_classes[] = ! empty( $atts['hide_indicates_required'] ) && 'yes' === $atts['hide_indicates_required'] ? 'qodef--hide-indicates-required' : '';

			return implode( ' ', $holder_classes );
		}
	}
}
