<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_numbered_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_numbered_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Numbered_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_numbered_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Numbered_Slider_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_numbered_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/numbered-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_numbered_slider' );
			$this->set_name( esc_html__( 'Numbered Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays numbered slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/numbered-slider/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#numbered_slider' );
			$this->set_video( 'https://www.youtube.com/watch?v=9GwC8zILPr0' );

			$this->map_slider_options(
				array(
					'exclude_option' => array(
						'loop',
						'centered',
						'columns',
						'space',
						'slider_navigation',
						'slider_speed_animation',
						'slider_pagination_position',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'number_of_columns',
					'title'         => esc_html__( 'Number of Columns', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'5' => esc_html__( '5', 'qi-addons-for-elementor-premium' ),
						'3' => esc_html__( '3', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => '5',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'change_slides_on_scroll',
					'title'         => esc_html__( 'Change Slides On Scroll', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_full_height',
					'title'         => esc_html__( 'Enable Full Height Slider', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image'    => $placeholder,
							'item_title'    => esc_html__( 'Example Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'item_image'    => $placeholder,
							'item_title'    => esc_html__( 'Example Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_title',
							'title'      => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_subtitle',
							'title'      => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_width',
					'title'      => esc_html__( 'Content Width (%)', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-inner' => 'width: {{SIZE}}%;',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'content_padding',
					'title'      => esc_html__( 'Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'overlay_color',
					'title'      => esc_html__( 'Overlay Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-lines .qodef-e-line:after' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-inner' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-items-slider .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-items-slider .qodef-e-title',
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-items-slider .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-items-slider .qodef-e-subtitle',
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'number_alignment',
					'title'         => esc_html__( 'Number Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-e-item-number-wrapper' => '{{VALUE}}: 0;',
					),
					'default_value' => 'bottom',
					'group'         => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'number_position_offset',
					'title'      => esc_html__( 'Number Position Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-number-wrapper' => 'padding-{{number_alignment.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'number_color',
					'title'      => esc_html__( 'Number Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-number-wrapper .qodef-e-item-number' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'number_typography',
					'title'      => esc_html__( 'Number Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-item-number-wrapper .qodef-e-item-number',
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'number_stroke_effect',
					'title'      => esc_html__( 'Number Stroke Effect', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'number_stroke_color',
					'title'      => esc_html__( 'Number Stroke Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-number-wrapper .qodef-e-item-number' => '-webkit-text-stroke-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'number_stroke_effect' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'number_stroke_width',
					'title'      => esc_html__( 'Number Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-number-wrapper .qodef-e-item-number' => '-webkit-text-stroke-width: {{SIZE}}px;',
					),
					'dependency' => array(
						'show' => array(
							'number_stroke_effect' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-items-slider .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-items-slider .qodef-e-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['slider_pagination_position'] = 'inside';

			$atts['holder_classes']    = $this->get_holder_classes( $atts );
			$atts['items']             = $this->parse_repeater_items( $atts['children'] );
			$atts['image_slider_attr'] = $this->get_image_slider_data( $atts );
			$atts['item_slider_attr']  = $this->get_item_slider_data( $atts );
			$atts['button_params']     = $this->generate_button_params( $atts );
			$atts['this_shortcode']    = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/numbered-slider', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-numbered-slider';
			$holder_classes[] = ! empty( $atts['number_of_columns'] ) ? 'qodef-cols--' . $atts['number_of_columns'] : 'qodef-cols--5';
			$holder_classes[] = ! empty( $atts['enable_full_height'] ) && 'yes' === $atts['enable_full_height'] ? 'qodef--full-height' : '';
			$holder_classes[] = ( 'yes' === $atts['number_stroke_effect'] ) ? 'qodef-number-stroke-effect' : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_slider_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		private function get_item_slider_data( $atts ) {
			$atts['effect']       = 'fade';
			$atts['slider_loop']  = 'no';

			$scroll = ! empty( $atts['change_slides_on_scroll'] ) && 'yes' === $atts['change_slides_on_scroll'] ? true : false;

			$include = array(
				'sliderScroll' => $scroll,
			);
			return $this->get_slider_data( $atts, $include );
		}

		private function get_image_slider_data( $atts ) {
			$atts['effect']            = 'fade';
			$atts['slider_loop']       = 'no';
			$atts['slider_pagination'] = 'no';
			$atts['slider_autoplay']   = 'no';

			return $this->get_slider_data( $atts );
		}

		private function generate_button_params( $atts ) {
			$atts['button_link'] = array(
				'url'               => '',
				'is_external'       => '',
				'nofollow'          => '',
				'custom_attributes' => '',
			);

			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}
	}
}
