<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_premium_button_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_premium_button_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Premium_Button_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_premium_button_shortcode', 9 );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Premium_Button_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_premium_button_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_premium_button_extra_options', array(), $this ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/premium-button' );
			$this->set_base( 'qi_addons_for_elementor_premium_premium_button' );
			$this->set_name( esc_html__( 'Premium Button', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays premium button with provided parameters', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Typography', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/premium-button/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#premium_button' );
			$this->set_scripts(
				array(
					'gsap'             => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'svg',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_text',
					'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Click Here', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'link',
					'name'       => 'button_link',
					'title'      => esc_html__( 'Button Link', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_underline',
					'title'         => esc_html__( 'Enable Button Text Underline', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'button_typography',
					'title'      => esc_html__( 'Typography', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-premium-button',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-premium-button' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'button_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'button_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-premium-button .qodef-m-text' => 'color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'button_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'button_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_color',
					'title'      => esc_html__( 'Text Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-premium-button:hover .qodef-m-text' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'button_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'button_style_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_button_tab_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_text_rotate',
					'title'      => esc_html__( 'Button Text Rotate', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => - 180,
							'max' => 180,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-text' => 'transform: rotate({{SIZE}}deg);',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-premium-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			// Button Underline Options
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'button_underline_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'button_underline_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_underline_color',
					'title'      => esc_html__( 'Underline Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-text:after' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'button_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_underline_width',
					'title'      => esc_html__( 'Underline Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-text:after' => 'width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'button_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'button_underline_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'button_underline_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_underline_hover_color',
					'title'      => esc_html__( 'Underline Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-premium-button.qodef-text-underline:hover .qodef-m-text:after' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'button_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_underline_hover_width',
					'title'      => esc_html__( 'Underline Hover Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-premium-button.qodef-text-underline:hover .qodef-m-text:after' => 'width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'hide'     => array(
							'button_underline_draw' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
							'button_underline'      => array(
								'values'        => 'no',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_underline_draw',
					'title'         => esc_html__( 'Enable Hover Underline Draw', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes' ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'button_underline_alignment' => array(
								'values'        => array( 'left', 'right' ),
								'default_value' => 'left',
							),
						),
					),
					'group'         => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'button_underline_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'button_underline_style_tabs_end',
					'title'      => esc_html__( 'Underline End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_button_tab_underline_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_underline_offset',
					'title'      => esc_html__( 'Underline Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => - 20,
							'max' => 20,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-text:after' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'button_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_underline_thickness',
					'title'      => esc_html__( 'Underline Thickness', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-text:after' => 'height: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'button_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'button_underline_alignment',
					'title'      => esc_html__( 'Underline Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
						'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
					),
					'dependency' => array(
						'show' => array(
							'button_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Underline Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'array',
					'name'       => 'custom_attrs',
					'title'      => esc_html__( 'Custom Data Attributes', 'qi-addons-for-elementor-premium' ),
					'visibility' => array(
						'map_for_page_builder' => false,
					),
				)
			);
			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();
			wp_enqueue_script( 'gsap' );
		}

		public static function call_shortcode( $params ) {
			$html = qi_addons_for_elementor_framework_call_shortcode( 'qi_addons_for_elementor_premium_premium_button', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {

			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['data_attrs']     = $this->get_data_attrs( $atts );
			$atts['this_shortcode'] = $this;

			$button_svg_url = esc_url( wp_get_attachment_url( $atts['button_svg'] ) );

			$atts['button_icon'] = array(
				'library' => 'svg',
				'value'   => array(
					'url' => $button_svg_url,
					'id'  => $atts['button_svg'],
				),
			);

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/premium-button', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}


		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-premium-button';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['button_svg_type'] ) ? 'qodef-svg--' . $atts['button_svg_type'] : '';
			$holder_classes[] = 'yes' === $atts['button_underline'] ? 'qodef-text-underline' : '';
			$holder_classes[] = ! empty( $atts['button_underline_alignment'] ) ? 'qodef-underline--' . $atts['button_underline_alignment'] : '';
			$holder_classes[] = 'yes' === $atts['button_underline_draw'] ? 'qodef-button-underline-draw' : '';
			$holder_classes[] = ! empty( $atts['gradient_hover_animation'] ) ? 'qodef-hover--gradient-' . $atts['gradient_hover_animation'] : '';
			$holder_classes[] = ! empty( $atts['svg_hover_animation'] ) ? 'qodef-hover--svg-' . $atts['svg_hover_animation'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_data_attrs( $atts ) {
			$data = qi_addons_for_elementor_get_link_attributes( $atts['button_link'] );

			if ( ! empty( $atts['custom_attrs'] ) && is_array( $atts['custom_attrs'] ) ) {
				$data = array_merge( $data, $atts['custom_attrs'] );
			}

			return $data;
		}
	}
}
