<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_premium_button_variation_gradient' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_filter_premium_button_variation_gradient( $variations ) {
		$variations['gradient'] = esc_html__( 'Gradient', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_premium_button_layouts', 'qi_addons_for_elementor_premium_filter_premium_button_variation_gradient' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_premium_button_gradient_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_filter_premium_button_gradient_add_extra_options( $extra_options ) {
		$with_gradient = array();

		$gradient_animation = array(
			'field_type' => 'select',
			'name'       => 'gradient_hover_animation',
			'title'      => esc_html__( 'Gradient Hover Animation', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Gradient Style', 'qi-addons-for-elementor-premium' ),
			'options'    => array(
				'vertical'   => esc_html__( 'Vertical', 'qi-addons-for-elementor-premium' ),
				'horizontal' => esc_html__( 'Horizontal', 'qi-addons-for-elementor-premium' ),
				''           => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => 'horizontal',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
		);

		$gradient_repeater = array(
			'field_type'    => 'repeater',
			'name'          => 'gradient_colors',
			'title'         => esc_html__( 'Colors', 'qi-addons-for-elementor-premium' ),
			'group'         => esc_html__( 'Gradient Style', 'qi-addons-for-elementor-premium' ),
			'default_value' => array(
				array(
					'item_color'       => '#00ffff',
					'color_percentage' => array(
						'size' => 0,
						'unit' => 'px',
					),
				),
				array(
					'item_color'       => '#ffffff',
					'color_percentage' => array(
						'size' => 100,
						'unit' => 'px',
					),
				),
			),
			'items'         => array(
				array(
					'field_type'    => 'color',
					'name'          => 'item_color',
					'title'         => esc_html__( 'Color', 'qi-addons-for-elementor-premium' ),
					'default_value' => '#00ff00',
				),
				array(
					'field_type'    => 'slider',
					'name'          => 'color_percentage',
					'title'         => esc_html__( 'Percent', 'qi-addons-for-elementor-premium' ),
					'range'         => array(
						'px' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'default_value' => array(
						'size' => 100,
						'unit' => 'px',
					),
				),
			),
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
		);

		$gradient_degree = array(
			'field_type'    => 'slider',
			'name'          => 'gradient_degree',
			'title'         => esc_html__( 'Gradient Degree', 'qi-addons-for-elementor-premium' ),
			'size_units'    => array( 'px' ),
			'range'         => array(
				'px' => array(
					'min' => - 180,
					'max' => 180,
				),
			),
			'default_value' => array(
				'size' => 180,
				'unit' => 'px',
			),
			'group'         => esc_html__( 'Gradient Style', 'qi-addons-for-elementor-premium' ),
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
		);

		$button_gradient_border_radius = array(
			'field_type' => 'dimensions',
			'name'       => 'button_border_radius',
			'title'      => esc_html__( 'Border Radius', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%' ),
			'range'      => array(
				'px' => array(
					'min' => 0,
					'max' => 200,
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--gradient' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$button_gradient_box_shadow = array(
			'field_type' => 'box_shadow',
			'name'       => 'button_gradient_box_shadow',
			'title'      => esc_html__( 'Box Shadow', 'qi-addons-for-elementor-premium' ),
			'selector'   => '{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--gradient',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$with_gradient[] = $gradient_animation;
		$with_gradient[] = $gradient_repeater;
		$with_gradient[] = $gradient_degree;
		$with_gradient[] = $button_gradient_border_radius;
		$with_gradient[] = $button_gradient_box_shadow;

		return array_merge( $extra_options, $with_gradient );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_premium_button_extra_options', 'qi_addons_for_elementor_premium_filter_premium_button_gradient_add_extra_options' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_premium_button_gradient_style' ) ) {
	function qi_addons_for_elementor_premium_premium_button_gradient_style( $params ) {
		$style = '';

		$gradient_colors = $params['this_shortcode']->parse_repeater_items( $params['gradient_colors'] );

		if ( count( $gradient_colors ) ) {
			$style = 'background-image: linear-gradient(' . $params['gradient_degree']['size'] . 'deg';

			foreach ( $gradient_colors as $color ) {
				$style .= ',' . $color['item_color'] . ' ' . $color['color_percentage']['size'] . '%';
			}

			$style .= ')';
		}

		return $style;
	}
}
