<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_premium_button_variation_svg' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_filter_premium_button_variation_svg( $variations ) {
		$variations['svg'] = esc_html__( 'With Svg Background', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_premium_button_layouts', 'qi_addons_for_elementor_premium_filter_premium_button_variation_svg' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_premium_button_svg_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_filter_premium_button_svg_add_extra_options( $extra_options ) {
		$with_svg = array();

		$svg = array(
			'field_type'    => 'image',
			'name'          => 'button_svg',
			'title'         => esc_html__( 'Svg', 'qi-addons-for-elementor-premium' ),
			'media_types'   => array( 'svg' ),
			'default_value' => array(),
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_type = array(
			'field_type'    => 'select',
			'name'          => 'button_svg_type',
			'title'         => esc_html__( 'Svg Type', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'cover' => esc_html__( 'Svg Cover', 'qi-addons-for-elementor-premium' ),
				'full'  => esc_html__( 'Svg Full Size', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => 'cover',
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_start = array(
			'field_type' => 'start_controls_tabs',
			'name'       => 'button_svg_style_tabs',
			'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_animation = array(
			'field_type'    => 'select',
			'name'          => 'svg_hover_animation',
			'title'         => esc_html__( 'Svg Hover Animation', 'qi-addons-for-elementor-premium' ),
			'group'         => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'scale'           => esc_html__( 'Scale', 'qi-addons-for-elementor-premium' ),
				'rotate'          => esc_html__( 'Rotate', 'qi-addons-for-elementor-premium' ),
				'rotate-infinite' => esc_html__( 'Rotate Infinite', 'qi-addons-for-elementor-premium' ),
				'move-up'         => esc_html__( 'Move Up', 'qi-addons-for-elementor-premium' ),
				'move-up-scale'   => esc_html__( 'Move Up And Scale', 'qi-addons-for-elementor-premium' ),
				'skew'            => esc_html__( 'Skew', 'qi-addons-for-elementor-premium' ),
				'follow-mouse'    => esc_html__( 'Follow Mouse', 'qi-addons-for-elementor-premium' ),
				'float'           => esc_html__( 'Float', 'qi-addons-for-elementor-premium' ),
				'hide'            => esc_html__( 'Hide', 'qi-addons-for-elementor-premium' ),
				'rotate-button'   => esc_html__( 'Rotate Button', 'qi-addons-for-elementor-premium' ),
				''                => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => 'scale',
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_normal_start = array(
			'field_type' => 'start_controls_tab',
			'name'       => 'button_svg_tab_normal',
			'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_fill = array(
			'field_type' => 'color',
			'name'       => 'button_svg_fill_color',
			'title'      => esc_html__( 'Svg Fill Color', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--svg .qodef-m-svg svg' => 'fill: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke = array(
			'field_type' => 'color',
			'name'       => 'button_svg_stroke_color',
			'title'      => esc_html__( 'Svg Stroke Color', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--svg .qodef-m-svg svg' => 'stroke: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke_dashoffset = array(
			'field_type' => 'number',
			'name'       => 'button_svg_stroke_dashoffset',
			'title'      => esc_html__( 'Svg Stroke DashOffset', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-svg svg' => 'stroke-dashoffset: {{VALUE}};',
			),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_normal_end = array(
			'field_type' => 'end_controls_tab',
			'name'       => 'button_tab_svg_normal_end',
			'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_hover_start = array(
			'field_type' => 'start_controls_tab',
			'name'       => 'button_tab_svg_hover',
			'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_fill_hover = array(
			'field_type' => 'color',
			'name'       => 'button_svg_fill_hover_color',
			'title'      => esc_html__( 'Svg Fill Hover Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--svg:hover .qodef-m-svg svg' => 'fill: {{VALUE}};',
			),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke_hover = array(
			'field_type' => 'color',
			'name'       => 'button_svg_stroke_hover_color',
			'title'      => esc_html__( 'Svg Stroke Hover Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--svg:hover .qodef-m-svg svg' => 'stroke: {{VALUE}};',
			),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke_dashoffset_hover = array(
			'field_type' => 'number',
			'name'       => 'button_svg_stroke_dashoffset_hover',
			'title'      => esc_html__( 'Svg Stroke DashOffset Hover', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-premium-button.qodef-layout--svg:hover .qodef-m-svg svg' => 'stroke-dashoffset: {{VALUE}};',
			),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_hover_end = array(
			'field_type' => 'end_controls_tab',
			'name'       => 'button_tab_svg_hover_end',
			'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_end = array(
			'field_type' => 'end_controls_tabs',
			'name'       => 'button_style_svg_tabs_end',
			'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_tabs_divider = array(
			'field_type' => 'divider',
			'name'       => 'item_divider_button_tab_svg_style',
			'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke_width = array(
			'field_type' => 'slider',
			'name'       => 'button_svg_stroke_width',
			'title'      => esc_html__( 'Svg Stroke Width', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-svg svg' => 'stroke-width: {{SIZE}};',
			),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke_dasharray = array(
			'field_type'  => 'text',
			'name'        => 'button_svg_stroke_dasharray',
			'title'       => esc_html__( 'Svg Stroke DashArray', 'qi-addons-for-elementor-premium' ),
			'description' => esc_html__( 'Enter stroke dasharray as ex. 10 10', 'qi-addons-for-elementor-premium' ),
			'selectors'   => array(
				'{{WRAPPER}} .qodef-m-svg svg' => 'stroke-dasharray: {{VALUE}};',
			),
			'group'       => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency'  => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$svg_stroke_dashoffset_timing = array(
			'field_type' => 'slider',
			'name'       => 'button_svg_stroke_dashoffset_timing',
			'title'      => esc_html__( 'Svg Stroke DashOffset Timing (s)', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px' ),
			'range'      => array(
				'px' => array(
					'min'  => 0,
					'max'  => 10,
					'step' => 0.1,
				),
			),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-svg svg' => 'transition: stroke-dashoffset {{SIZE}}s ease-out, stroke .2s ease-out, fill .2s ease-out;',
			),
			'group'      => esc_html__( 'Svg Style', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'svg',
						'default_value' => '',
					),
				),
			),
		);

		$with_svg[] = $svg;
		$with_svg[] = $svg_type;
		$with_svg[] = $svg_animation;
		$with_svg[] = $svg_tabs_start;
		$with_svg[] = $svg_tabs_normal_start;
		$with_svg[] = $svg_fill;
		$with_svg[] = $svg_stroke;
		$with_svg[] = $svg_stroke_dashoffset;
		$with_svg[] = $svg_tabs_normal_end;
		$with_svg[] = $svg_tabs_hover_start;
		$with_svg[] = $svg_fill_hover;
		$with_svg[] = $svg_stroke_hover;
		$with_svg[] = $svg_stroke_dashoffset_hover;
		$with_svg[] = $svg_tabs_hover_end;
		$with_svg[] = $svg_tabs_end;
		$with_svg[] = $svg_tabs_divider;
		$with_svg[] = $svg_stroke_width;
		$with_svg[] = $svg_stroke_dasharray;
		$with_svg[] = $svg_stroke_dashoffset_timing;

		return array_merge( $extra_options, $with_svg );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_premium_button_extra_options', 'qi_addons_for_elementor_premium_filter_premium_button_svg_add_extra_options' );
}
