<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pricing_calculator_variation_side' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_pricing_calculator_variation_side( $variations ) {
		$variations['side'] = esc_html__( 'Side', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pricing_calculator_layouts', 'qi_addons_for_elementor_premium_add_pricing_calculator_variation_side' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_calculator_side_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_pricing_calculator_side_add_extra_options( $extra_options ) {
		$side = array();

		$number_of_columns = array(
			'field_type'    => 'slider',
			'name'          => 'side_number_of_columns',
			'title'         => esc_html__( 'Number of Columns', 'qi-addons-for-elementor-premium' ),
			'description'   => esc_html__( 'Choose number of columns for items', 'qi-addons-for-elementor-premium' ),
			'default_value' => array(
				'size' => 1,
				'unit' => 'px',
			),
			'range'         => array(
				'px' => array(
					'min' => 1,
					'max' => 5,
				),
			),
			'responsive'    => true,
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'selectors'     => array(
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-e-item' => 'width: calc( 100%/{{SIZE}} );',
			),
			'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$border_between_width = array(
			'field_type' => 'number',
			'name'       => 'side_border_between_columns_width',
			'title'      => esc_html__( 'Border Between Columns Width', 'qi-addons-for-elementor-premium' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-e-item'        => 'border-right-width: {{SIZE}}px;',
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-m-items:after' => 'border-width: {{SIZE}}px;',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$holder_width = array(
			'field_type'  => 'slider',
			'name'        => 'side_side_holder_width',
			'title'       => esc_html__( 'Side Holder Width', 'qi-addons-for-elementor-premium' ),
			'description' => esc_html__( 'Won\'t affect under 680px due to responsive', 'qi-addons-for-elementor-premium' ),
			'dependency'  => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'responsive'  => true,
			'selectors'   => array(
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-m-total-holder' => 'width: {{SIZE}}%;',
			),
			'group'       => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$holder_padding = array(
			'field_type' => 'dimensions',
			'name'       => 'side_holder_padding',
			'title'      => esc_html__( 'Holder Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-m-total-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$price_wrapper_margin_bottom = array(
			'field_type' => 'slider',
			'name'       => 'price_wrapper_margin_bottom',
			'title'      => esc_html__( 'Price Wrapper Margin Bottom', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-m-top-holder' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$item_padding = array(
			'field_type' => 'dimensions',
			'name'       => 'side_item_padding',
			'title'      => esc_html__( 'Item Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-calculator.qodef-layout--side .qodef-e-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$side[] = $number_of_columns;
		$side[] = $border_between_width;
		$side[] = $holder_width;
		$side[] = $holder_padding;
		$side[] = $price_wrapper_margin_bottom;
		$side[] = $item_padding;

		return array_merge( $extra_options, $side );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pricing_calculator_extra_options', 'qi_addons_for_elementor_premium_pricing_calculator_side_add_extra_options' );
}
