<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pricing_list_variation_with_image' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_pricing_list_variation_with_image( $variations ) {
		$variations['with-legend'] = esc_html__( 'With Legend Premium', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_list_layouts', 'qi_addons_for_elementor_premium_add_pricing_list_variation_with_image' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_list_with_legend_item_template' ) ) {
	function qi_addons_for_elementor_premium_pricing_list_with_legend_item_template( $template, $layout, $item ) {
		if ( 'with-legend' === $layout ) {
			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/pricing-list', 'variations/with-legend/templates/item', '', $item );
		} else {
			return $template;
		}
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_list_item_template', 'qi_addons_for_elementor_premium_pricing_list_with_legend_item_template', 10, 3 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_list_legend' ) ) {
	function qi_addons_for_elementor_premium_pricing_list_legend( $params ) {
		if ( 'with-legend' === $params['layout'] ) {
			qi_addons_for_elementor_premium_template_part( 'shortcodes/pricing-list', 'variations/with-legend/templates/legend', '', $params );
		}
	}

	add_action( 'qi_addons_for_elementor_action_pricing_list_after_items', 'qi_addons_for_elementor_premium_pricing_list_legend' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_list_with_legend_extra_options' ) ) {
	function qi_addons_for_elementor_premium_pricing_list_with_legend_extra_options( $options ) {
		$with_legend = array();

		$number_of_columns = array(
			'field_type'    => 'select',
			'name'          => 'with_legend_number_of_columns',
			'title'         => esc_html__( 'Number of Columns for Items', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'one'   => esc_html__( 'One', 'qi-addons-for-elementor-premium' ),
				'two'   => esc_html__( 'Two', 'qi-addons-for-elementor-premium' ),
				'three' => esc_html__( 'Three', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => 'one',
			'prefix_class'  => 'qodef-columns--',
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
		);

		$enable_responsive = array(
			'field_type'    => 'select',
			'name'          => 'with_legend_columns_responsive',
			'title'         => esc_html__( 'Enable Columns Responsive', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'1024'  => esc_html__( 'Under 1024px', 'qi-addons-for-elementor-premium' ),
				'680'   => esc_html__( 'Under 680px', 'qi-addons-for-elementor-premium' ),
				'never' => esc_html__( 'Never', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => '1024',
			'prefix_class'  => 'qodef-columns-responsive--',
			'dependency'    => array(
				'dependency' => 'and',
				'show'       => array(
					'layout'                        => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
					'with_legend_number_of_columns' => array(
						'values'        => array( 'two', 'three' ),
						'default_value' => 'one',
					),
				),
			),
		);

		$space_between_columns = array(
			'field_type' => 'slider',
			'name'       => 'with_legend_space_between_columns',
			'title'      => esc_html__( 'Space Between Columns', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'vw' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-inner' => 'column-gap: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'dependency' => 'and',
				'show'       => array(
					'layout'                        => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
					'with_legend_number_of_columns' => array(
						'values'        => array( 'two', 'three' ),
						'default_value' => 'one',
					),
				),
			),
			'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
		);

		$legend = array(
			'field_type'    => 'repeater',
			'name'          => 'legend_items',
			'title'         => esc_html__( 'Legend Items', 'qi-addons-for-elementor-premium' ),
			'default_value' => array(
				array(
					'legend_icon'          => array(
						'value'   => 'fas fa-seedling',
						'library' => 'fa-solid',
					),
					'add_to_items_indexes' => '1, 3',
					'legend_title'         => esc_html__( 'Legend Title 1', 'qi-addons-for-elementor-premium' ),
				),
				array(
					'legend_icon'          => array(
						'value'   => 'fas fa-carrot',
						'library' => 'fa-solid',
					),
					'add_to_items_indexes' => '3',
					'legend_title'         => esc_html__( 'Legend Title 2', 'qi-addons-for-elementor-premium' ),
				),
				array(
					'legend_icon'          => array(
						'value'   => 'fas fa-pepper-hot',
						'library' => 'fa-solid',
					),
					'add_to_items_indexes' => '2',
					'legend_title'         => esc_html__( 'Legend Title 3', 'qi-addons-for-elementor-premium' ),
				),
			),
			'items'         => array(
				array(
					'field_type'    => 'icons',
					'name'          => 'legend_icon',
					'title'         => esc_html__( 'Legend Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-quote-right',
						'library' => 'fa-solid',
					),
				),
				array(
					'field_type'    => 'text',
					'name'          => 'legend_title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Legend Title', 'qi-addons-for-elementor-premium' ),
				),
				array(
					'field_type'  => 'text',
					'name'        => 'add_to_items_indexes',
					'title'       => esc_html__( 'Items Indexes', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Enter indexes of items on which to add legend icon (ex. 1, 3)', 'qi-addons-for-elementor-premium' ),
				),
				array(
					'field_type' => 'color',
					'name'       => 'legend_icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}};',
					),
				),
				array(
					'field_type' => 'slider',
					'name'       => 'legend_list_icon_size',
					'title'      => esc_html__( 'List Icon Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} {{CURRENT_ITEM}}' => 'font-size: {{SIZE}}{{UNIT}};',
					),
				),
			),
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
		);

		$list_legend_icons_alignment = array(
			'field_type'    => 'select',
			'name'          => 'list_legend_icons_alignment',
			'title'         => esc_html__( 'List Legend Icons Alignment', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'flex-start' => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
				'center'     => esc_html__( 'Middle', 'qi-addons-for-elementor-premium' ),
				'flex-end'   => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
				'baseline'   => esc_html__( 'Baseline', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => 'center',
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'     => array(
				'{{WRAPPER}} .qodef-e-heading-title' => 'align-items: {{VALUE}};',
			),
			'group'         => esc_html__( 'Legend List Icon Style', 'qi-addons-for-elementor-premium' ),
		);

		$list_legend_icons_margin_left = array(
			'field_type' => 'slider',
			'name'       => 'list_legend_icons_margin_left',
			'title'      => esc_html__( 'List Legend Icons Margin Left', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-e-legend-list-icon-holder' => 'margin-left: {{SIZE}}{{UNIT}};',
			),
			'group'      => esc_html__( 'Legend List Icon Style', 'qi-addons-for-elementor-premium' ),
		);

		$list_legend_icons_space_between = array(
			'field_type' => 'slider',
			'name'       => 'list_legend_icons_space_between',
			'title'      => esc_html__( 'Space Between List Legend Icons', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-e-legend-list-icon:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
			),
			'group'      => esc_html__( 'Legend List Icon Style', 'qi-addons-for-elementor-premium' ),
		);

		$legend_margin_top = array(
			'field_type' => 'slider',
			'name'       => 'legend_margin_top',
			'title'      => esc_html__( 'Legend Margin Top', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'range'      => array(
				'px' => array(
					'min' => 0,
					'max' => 300,
				),
			),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-legend' => 'margin-top: {{SIZE}}{{UNIT}};',
			),
			'group'      => esc_html__( 'Legend Holder Style', 'qi-addons-for-elementor-premium' ),
		);

		$legend_title_color = array(
			'field_type' => 'color',
			'name'       => 'legend_title_color',
			'title'      => esc_html__( 'Legend Title Color', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-e-legend-description' => 'color: {{VALUE}};',
			),
			'group'      => esc_html__( 'Legend Holder Style', 'qi-addons-for-elementor-premium' ),
		);

		$legend_title_typography = array(
			'field_type' => 'typography',
			'name'       => 'legend_title_typography',
			'title'      => esc_html__( 'Legend Title Typography', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selector'   => '{{WRAPPER}} .qodef-e-legend-description',
			'group'      => esc_html__( 'Legend Holder Style', 'qi-addons-for-elementor-premium' ),
		);

		$legend_space_between_items = array(
			'field_type' => 'slider',
			'name'       => 'legend_space_between_items',
			'title'      => esc_html__( 'Space Between Legend Items', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-legend .qodef-e-legend-item:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'group'      => esc_html__( 'Legend Holder Style', 'qi-addons-for-elementor-premium' ),
		);

		$legend_icon_title_space = array(
			'field_type' => 'slider',
			'name'       => 'legend_icon_title_space',
			'title'      => esc_html__( 'Space Between Legend Icon and Title', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'with-legend',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-legend .qodef-e-legend-description' => 'margin-left: {{SIZE}}{{UNIT}};',
			),
			'group'      => esc_html__( 'Legend Holder Style', 'qi-addons-for-elementor-premium' ),
		);

		$with_legend[] = $number_of_columns;
		$with_legend[] = $enable_responsive;
		$with_legend[] = $space_between_columns;
		$with_legend[] = $legend;
		$with_legend[] = $list_legend_icons_alignment;
		$with_legend[] = $list_legend_icons_margin_left;
		$with_legend[] = $list_legend_icons_space_between;
		$with_legend[] = $legend_title_color;
		$with_legend[] = $legend_title_typography;
		$with_legend[] = $legend_margin_top;
		$with_legend[] = $legend_space_between_items;
		$with_legend[] = $legend_icon_title_space;

		return array_merge( $options, $with_legend );
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_list_extra_options', 'qi_addons_for_elementor_premium_pricing_list_with_legend_extra_options' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_items_legend' ) ) {
	function qi_addons_for_elementor_premium_pricing_items_legend( $items, $legends ) {
		$items_legend = array();

		foreach ( $items as $key => $item ) {
			$items_legend[ $key + 1 ] = array();
		}

		if ( count( $legends ) ) {
			foreach ( $legends as $legend_item ) {
				if ( empty( $legend_item['add_to_items_indexes'] ) ) {
					continue;
				}
				$legend_indexes = explode( ',', $legend_item['add_to_items_indexes'] );

				foreach ( $legend_indexes as $index ) {
					$icon_array = array(
						'icon'       => $legend_item['legend_icon'],
						'icon_class' => 'elementor-repeater-item-' . $legend_item['_id'],
					);

					$items_legend[ intval( $index ) ][] = $icon_array;
				}
			}
		}

		return $items_legend;
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_list_additional_params' ) ) {
	function qi_addons_for_elementor_premium_pricing_list_additional_params( $additional, $params, $item ) {
		if ( 'with-legend' === $params['layout'] ) {
			$additional['items_icons'] = qi_addons_for_elementor_premium_pricing_items_legend( $params['items'], $params['this_shortcode']->parse_repeater_items( $params['legend_items'] ) );
		}
		return $additional;
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_list_additional_params', 'qi_addons_for_elementor_premium_pricing_list_additional_params', 10, 3 );
}
