<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pricing_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_pricing_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Pricing_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_pricing_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Pricing_Slider_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_pricing_slider_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_pricing_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/pricing-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_pricing_slider' );
			$this->set_name( esc_html__( 'Pricing Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays pricing slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/pricing-slider/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#pricing_slider' );
			$this->set_video( 'https://www.youtube.com/watch?v=pzbFxq-2mmA' );

			$this->set_scripts(
				array(
					'jquery-ui-draggable' => array(
						'registered' => true,
					),
					'jquery-ui-touch-punch' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_URL_PATH . '/shortcodes/pricing-slider/assets/js/plugins/jquery-ui-touch-punch.min.js',
						'dependency' => array( 'jquery', 'jquery-ui-draggable' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'side',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'unit_name',
					'title'         => esc_html__( 'Unit Name', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'unit_name_plural',
					'title'         => esc_html__( 'Unit Name Plural', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'units_range',
					'title'         => esc_html__( 'Units range', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Enter maximum number of units you will charge (ex. 1000)', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'unit_step',
					'title'         => esc_html__( 'Unit Step', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Enter step by which units will increase', 'qi-addons-for-elementor-premium' ),
					'default_value' => '1',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'price_per_unit',
					'title'         => esc_html__( 'Price Per Unit', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Enter value of price that will be charged per unit (ex. 5)', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'breakpoints_type',
					'title'         => esc_html__( 'Breakpoints Type', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'interval'   => esc_html__( 'Interval Breakpoint', 'qi-addons-for-elementor-premium' ),
						'multiple' => esc_html__( 'Multiple Breakpoints', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'interval',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'units_breakpoints',
					'title'         => esc_html__( 'Units breakpoint', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Enter breakpoint value where price per unit will be reduced (ex. 100)', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
					'dependency'    => array(
						'show' => array(
							'breakpoints_type' => array(
								'values'        => 'interval',
								'default_value' => 'interval',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'price_reduce_per_breakpoint',
					'title'         => esc_html__( 'Price Reduce Per Breakpoint', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Enter value for which price will be reduced on each breakpoint (ex. 0.2)', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
					'dependency'    => array(
						'show' => array(
							'breakpoints_type' => array(
								'values'        => 'interval',
								'default_value' => 'interval',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'breakpoints_multiple',
					'title'      => esc_html__( 'Breakpoints', 'qi-addons-for-elementor-premium' ),
					'items'      => array(
						array(
							'field_type'    => 'number',
							'name'          => 'unit',
							'title'         => esc_html__( 'Unit Bottom Value', 'qi-addons-for-elementor-premium' ),
							'description'   => esc_html__( 'Enter value from which different price will be set (ex. from 50 up)', 'qi-addons-for-elementor-premium' ),
							'default_value' => '',
						),
						array(
							'field_type' => 'text',
							'name'       => 'price',
							'title'      => esc_html__( 'Price', 'qi-addons-for-elementor-premium' ),
						),
					),
					'dependency' => array(
						'show' => array(
							'breakpoints_type' => array(
								'values'        => 'multiple',
								'default_value' => 'interval',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_icon',
					'title'         => esc_html__( 'Enable Icon', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'icons',
					'name'       => 'icon_type',
					'title'      => esc_html__( 'Icon Type', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'enable_icon' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_separator',
					'title'      => esc_html__( 'Enable Separator', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'description',
					'title'         => esc_html__( 'Description', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'currency',
					'title'         => esc_html__( 'Currency', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( '$', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'period',
					'title'         => esc_html__( 'Period', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( '/mo', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_text',
					'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Purchase Now', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'link',
					'name'       => 'button_link',
					'title'      => esc_html__( 'Button Url', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'info_image',
					'title'      => esc_html__( 'Info Image', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_width',
					'title'      => esc_html__( 'Info Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-pricing-slider .qodef-m-info' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'choose',
					'name'          => 'info_alignment',
					'title'         => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive'    => true,
					'selectors'     => array(
						'{{WRAPPER}} .qodef-qi-pricing-slider .qodef-m-info'        => 'text-align: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-pricing-slider .qode-m-price-holder' => 'justify-content: {{VALUE}};',
					),
					'group'         => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'center'
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Info Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-pricing-slider .qodef-m-info' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_color',
					'title'      => esc_html__( 'Info Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-pricing-slider .qodef-m-info-inner' => 'border-color: {{VALUE}};',
					),
					'alpha'      => false,
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'border_width',
					'title'      => esc_html__( 'Info Border Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-pricing-slider .qodef-m-info-inner' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'slider_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'slider_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);


			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'slider_background_color',
					'title'      => esc_html__( 'Line Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);


			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'slider_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'slider_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'slider_active_background_color',
					'title'      => esc_html__( 'Line Active Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-bar' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'slider_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'slider_style_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'line_height',
					'title'      => esc_html__( 'Line Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider' => 'height: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_slider_tab_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'drag_color',
					'title'      => esc_html__( 'Drag Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'drag_width',
					'title'      => esc_html__( 'Drag Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'width: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'drag_height',
					'title'      => esc_html__( 'Drag Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'height: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'drag_top_position',
					'title'      => esc_html__( 'Drag Top Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'top: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'drag_border_color',
					'title'      => esc_html__( 'Drag Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'border-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'drag_border_width',
					'title'      => esc_html__( 'Drag Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'drag_border_radius',
					'title'      => esc_html__( 'Drag Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'drag_arrows_color',
					'title'      => esc_html__( 'Drag Arrows Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-drag .qodef-m-arrow-left'  => 'fill: {{VALUE}};',
						'{{WRAPPER}} .qodef-m-slider-drag .qodef-m-arrow-right' => 'fill: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'slider_bottom_margin',
					'title'      => esc_html__( 'Slider Bottom Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'title_padding',
					'title'      => esc_html__( 'Title Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h6',
					'group'         => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_background_color',
					'title'      => esc_html__( 'Info Title Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Info Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Info Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-title',
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);


			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'price_padding',
					'title'      => esc_html__( 'Price Holder Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qode-m-price-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'price_background_color',
					'title'      => esc_html__( 'Info Price Holder Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qode-m-price-holder' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'price_color',
					'title'      => esc_html__( 'Info Price Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-total-price' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'price_typography',
					'title'      => esc_html__( 'Info Price Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-total-price',
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'currency_color',
					'title'      => esc_html__( 'Info Currency Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-currency' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'currency_typography',
					'title'      => esc_html__( 'Info Currency Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-currency',
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'period_color',
					'title'      => esc_html__( 'Info Period Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-period' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'period_typography',
					'title'      => esc_html__( 'Info Period Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-period',
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'currency_margin',
					'title'      => esc_html__( 'Info Currency Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-currency' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'period_margin',
					'title'              => esc_html__( 'Info Period Margin', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'bottom', 'left' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-m-period' => 'margin: 0 0 {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Info Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'description_padding',
					'title'      => esc_html__( 'Description Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Description Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'description_color',
					'title'      => esc_html__( 'Info Description Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-description' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Description Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'description_typography',
					'title'      => esc_html__( 'Info Description Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-description',
					'group'      => esc_html__( 'Info Description Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_separator',
					'exclude'           => array( 'custom_class' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Info Separator', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'separator_padding',
					'title'      => esc_html__( 'Separator Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-info .qodef-qi-separator' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Separator Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_link', 'button_text' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Info Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_holder_padding',
					'title'      => esc_html__( 'Button Holder Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-info .qodef-m-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'info_holder_padding',
					'title'      => esc_html__( 'Holder Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-info-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_margin_bottom',
					'title'      => esc_html__( 'Info Icon Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-icon-holder' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'enable_icon' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Info Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Info Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'price_wrapper_margin_bottom',
					'title'      => esc_html__( 'Price Wrapper Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_margin_top',
					'title'      => esc_html__( 'Info Button Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-button' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'slider_delimiter_background_color',
					'title'      => esc_html__( 'Slider Delimiter Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-delimiter' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Delimiter Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'slider_delimiter_width',
					'title'      => esc_html__( 'Delimiter Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-delimiter' => 'width: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Slider Delimiter Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'slider_delimiter_height',
					'title'      => esc_html__( 'Delimiter Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-delimiter' => 'height: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Slider Delimiter Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'slider_value_color',
					'title'      => esc_html__( 'Slider Value Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-value-holder .qodef-m-slider-value' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Slider Value Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'slider_value_typography',
					'title'      => esc_html__( 'Slider Value Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-slider-value-holder .qodef-m-slider-value',
					'group'      => esc_html__( 'Slider Value Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'slider_value_margin',
					'title'      => esc_html__( 'Slider Top Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slider-value-holder' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Slider Value Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']   = $this->get_holder_classes( $atts );
			$atts['breakpoints']      = $this->sortBreakpoints( $this->parse_repeater_items( $atts['breakpoints_multiple'] ) );
			$atts['slider_data']      = $this->getSliderData( $atts );
			$atts['total_price']      = $this->getPrice( $atts );
			$atts['button_params']    = $this->generate_button_params( $atts );
			$atts['separator_params'] = $this->generate_separator_params( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/pricing-slider', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-pricing-slider';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['info_image'] ) ? 'qodef--with-image' : '';

			$holder_classes = apply_filters( 'qi_addons_for_elementor_filter_pricing_slider_holder_classes', $holder_classes, $atts );

			return implode( ' ', $holder_classes );
		}

		private function getPrice( $atts ) {

			$total_price = 0;

			return $total_price;
		}

		private function sortBreakpoints( $breakpoints ) {
			if ( is_array( $breakpoints ) && count( $breakpoints ) ) {
				$unit = array_column( $breakpoints, 'unit' );

				// Sort the data with unit descending, easier for later use in js
				array_multisort( $unit, SORT_DESC, $breakpoints );
			}

			return $breakpoints;
		}

		private function getSliderData( $atts ) {

			$slider_data = array();

			if ( '' !== $atts['units_range'] ) {
				$slider_data['data-units-range'] = $atts['units_range'];
			}

			if ( '' !== $atts['unit_step'] ) {
				$slider_data['data-unit-step'] = $atts['unit_step'];
			}

			if ( isset( $atts['breakpoints_type'] ) ) {
				$slider_data['data-breakpoints-type'] = $atts['breakpoints_type'];
			}

			if ( 'multiple' === $atts['breakpoints_type'] ) {
				if ( is_array( $atts['breakpoints'] ) && count( $atts['breakpoints'] ) ) {
					$slider_data['data-breakpoints-multiple'] = json_encode( $atts['breakpoints'] );
				}
			} else {

				if ( '' !== $atts['units_breakpoints'] ) {
					$slider_data['data-units-breakpoints'] = $atts['units_breakpoints'];
				}

				if ( '' !== $atts['price_reduce_per_breakpoint'] ) {
					$slider_data['data-price-reduce-per-breakpoint'] = $atts['price_reduce_per_breakpoint'];
				}
			}

			if ( '' !== $atts['unit_name'] ) {
				$slider_data['data-unit-name'] = $atts['unit_name'];
			}

			if ( '' !== $atts['unit_name_plural'] ) {
				$slider_data['data-unit-name-plural'] = $atts['unit_name_plural'];
			}

			if ( '' !== $atts['price_per_unit'] ) {
				$slider_data['data-price-per-unit'] = $atts['price_per_unit'];
			}

			return $slider_data;
		}

		private function generate_button_params( $atts ) {

			if ( '' !== $atts['button_text'] ) {
				return $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
			}

			return array();
		}

		private function generate_separator_params( $atts ) {
			$params = array();

			if ( 'yes' === $atts['enable_separator'] ) {
				$params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_separator',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
			}

			return $params;
		}
	}
}
