<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pricing_slider_variation_side' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_pricing_slider_variation_side( $variations ) {
		$variations['side'] = esc_html__( 'Side', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pricing_slider_layouts', 'qi_addons_for_elementor_premium_add_pricing_slider_variation_side' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_slider_side_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_pricing_slider_side_add_extra_options( $extra_options ) {
		$side = array();


		$slider_position = array(
			'field_type' => 'select',
			'name'       => 'slider_position',
			'title'      => esc_html__( 'Slider Position', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
				'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'default_value' => 'left',
		);

		$slider_horizontal_align= array(
			'field_type' => 'select',
			'name'       => 'slider_align',
			'title'      => esc_html__( 'Horizontal Align', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'' => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
				'flex-start' => esc_html__( 'Start', 'qi-addons-for-elementor-premium' ),
				'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
				'flex-end' => esc_html__( 'End', 'qi-addons-for-elementor-premium' ),
				'space-between' => esc_html__( 'Space Between', 'qi-addons-for-elementor-premium' ),
				'space-around' => esc_html__( 'Space Around', 'qi-addons-for-elementor-premium' ),
				'space-evenly' => esc_html__( 'Space Evenly', 'qi-addons-for-elementor-premium' ),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-slider' =>  'justify-content: {{VALUE}}',
			),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'default_value' => '',
		);

		$slider_holder_padding = array(
			'field_type' => 'dimensions',
			'name'       => 'slider_holder_padding',
			'title'      => esc_html__( 'Slider Holder Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_subtitle = array(
			'field_type' => 'text',
			'name'       => 'slider_subtitle',
			'title'      => esc_html__( 'Slider Subtitle', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Info', 'qi-addons-for-elementor-premium' ),
		);

		$slider_title = array(
			'field_type' => 'text',
			'name'       => 'slider_title',
			'title'      => esc_html__( 'Slider Title', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Info', 'qi-addons-for-elementor-premium' ),
		);


		$slider_description = array(
			'field_type' => 'textarea',
			'name'       => 'slider_description',
			'title'      => esc_html__( 'Slider Description', 'qi-addons-for-elementor-premium' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Info', 'qi-addons-for-elementor-premium' ),
		);

		$slider_subtitle_tag = array(
			'field_type'    => 'select',
			'name'          => 'slider_subtitle_tag',
			'title'         => esc_html__( 'Slider Subtitle Tag', 'qi-addons-for-elementor-premium' ),
			'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
			'default_value' => 'h6',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'         => esc_html__( 'Slider Subtitle Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_subtitle_color = array(
			'field_type' => 'color',
			'name'       => 'slider_subtitle_color',
			'title'      => esc_html__( 'Slider Subtitle Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-subtitle' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Subtitle Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_subtitle_typography = array(
			'field_type' => 'typography',
			'name'       => 'slider_subtitle_typography',
			'title'      => esc_html__( 'Slider Subtitle Typography', 'qi-addons-for-elementor-premium' ),
			'selector'   => '{{WRAPPER}} .qodef-m-slider-subtitle',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Subtitle Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_subtitle_bottom_margin = array(
			'field_type' => 'slider',
			'name'       => 'slider_subtitle_bottom_margin',
			'title'      => esc_html__( 'Slider Subtitle Bottom Margin', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Subtitle Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_title_tag = array(
			'field_type'    => 'select',
			'name'          => 'slider_title_tag',
			'title'         => esc_html__( 'Slider Title Tag', 'qi-addons-for-elementor-premium' ),
			'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
			'default_value' => 'h6',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'         => esc_html__( 'Slider Title Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_title_color = array(
			'field_type' => 'color',
			'name'       => 'slider_title_color',
			'title'      => esc_html__( 'Slider Title Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-title' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Title Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_title_typography = array(
			'field_type' => 'typography',
			'name'       => 'slider_title_typography',
			'title'      => esc_html__( 'Slider Title Typography', 'qi-addons-for-elementor-premium' ),
			'selector'   => '{{WRAPPER}} .qodef-m-slider-title',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Title Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_title_bottom_margin = array(
			'field_type' => 'slider',
			'name'       => 'slider_title_bottom_margin',
			'title'      => esc_html__( 'Slider Title Bottom Margin', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Title Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_description_color = array(
			'field_type' => 'color',
			'name'       => 'slider_description_color',
			'title'      => esc_html__( 'Slider Description Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-description' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Description Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_description_typography = array(
			'field_type' => 'typography',
			'name'       => 'slider_description_typography',
			'title'      => esc_html__( 'Slider Description Typography', 'qi-addons-for-elementor-premium' ),
			'selector'   => '{{WRAPPER}} .qodef-m-slider-description',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Description Style', 'qi-addons-for-elementor-premium' ),
		);

		$slider_description_padding = array(
			'field_type' => 'dimensions',
			'name'       => 'slider_description_padding',
			'title'      => esc_html__( 'Slider Description Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-slider-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Slider Description Style', 'qi-addons-for-elementor-premium' ),
		);

		$side[] = $slider_position;
		$side[] = $slider_horizontal_align;
		$side[] = $slider_holder_padding;
		$side[] = $slider_subtitle;
		$side[] = $slider_title;
		$side[] = $slider_description;
		$side[] = $slider_subtitle_tag;
		$side[] = $slider_subtitle_color;
		$side[] = $slider_subtitle_typography;
		$side[] = $slider_subtitle_bottom_margin;
		$side[] = $slider_title_tag;
		$side[] = $slider_title_color;
		$side[] = $slider_title_typography;
		$side[] = $slider_title_bottom_margin;
		$side[] = $slider_description_color;
		$side[] = $slider_description_typography;
		$side[] = $slider_description_padding;

		return array_merge( $extra_options, $side );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pricing_slider_extra_options', 'qi_addons_for_elementor_premium_pricing_slider_side_add_extra_options' );
}


if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_slider_side_add_holder_classes' ) ) {
	function qi_addons_for_elementor_premium_pricing_slider_side_add_holder_classes( $holder_classes, $atts ) {

		$holder_classes[] = ! empty( $atts['slider_position'] ) ? 'qodef-slider--' . $atts['slider_position'] : '';

		return $holder_classes;
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_slider_holder_classes', 'qi_addons_for_elementor_premium_pricing_slider_side_add_holder_classes', 10, 2 );
}
