<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pricing_slider_variation_simple' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_pricing_slider_variation_simple( $variations ) {
		$variations['simple'] = esc_html__( 'Simple', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pricing_slider_layouts', 'qi_addons_for_elementor_premium_add_pricing_slider_variation_simple' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_slider_simple_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_pricing_slider_simple_add_extra_options( $extra_options ) {
		$simple = array();

		$padding = array(
			'field_type' => 'dimensions',
			'name'       => 'simple_padding',
			'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-slider.qodef-layout--simple' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'simple',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$price_margin_bottom = array(
			'field_type' => 'slider',
			'name'       => 'simple_price_margin_bottom',
			'title'      => esc_html__( 'Price Margin Bottom', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-slider.qodef-layout--simple .qode-m-price-holder' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'simple',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$space_between_items = array(
			'field_type' => 'slider',
			'name'       => 'simple_space_between_items',
			'title'      => esc_html__( 'Space Between Items', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-slider.qodef-layout--simple .qodef-e-item:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'simple',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$items_holder_margin_bottom = array(
			'field_type' => 'slider',
			'name'       => 'simple_items_holder_margin_bottom',
			'title'      => esc_html__( 'Items Holder Margin Bottom', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-qi-pricing-slider.qodef-layout--simple .qodef-m-bottom-holder' => 'margin-top: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'simple',
						'default_value' => 'side',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$simple[] = $padding;
		$simple[] = $price_margin_bottom;
		$simple[] = $space_between_items;
		$simple[] = $items_holder_margin_bottom;

		return array_merge( $extra_options, $simple );
	}

	//add_filter( 'qi_addons_for_elementor_premium_filter_pricing_slider_extra_options', 'qi_addons_for_elementor_premium_pricing_slider_simple_add_extra_options' );
}
