<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pricing_table_variation_side_price' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_pricing_table_variation_side_price( $variations ) {
		$variations['side-price'] = esc_html__( 'Side Price', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_table_layouts', 'qi_addons_for_elementor_premium_add_pricing_table_variation_side_price', 15 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_table_render' ) ) {
	function qi_addons_for_elementor_premium_pricing_table_render( $template, $atts ) {
		if ( 'side-price' === $atts['layout'] ) {
			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/pricing-table', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		} else {
			return $template;
		}
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_table_render_template', 'qi_addons_for_elementor_premium_pricing_table_render', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_pricing_table_side_price_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_pricing_table_side_price_add_extra_options( $extra_options ) {
		$side_price = array();

		$side_price_margin_right = array(
			'field_type' => 'slider',
			'name'       => 'side_price_margin_right',
			'title'      => esc_html__( 'Side Margin Right', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'vw' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-m-side' => 'margin-right: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-price',
						'default_value' => 'standard',
					),
				),
			),
			'group'      => esc_html__( 'Table Style', 'qi-addons-for-elementor-premium' ),
		);

		$side_price[] = $side_price_margin_right;

		return array_merge( $extra_options, $side_price );
	}

	add_filter( 'qi_addons_for_elementor_filter_pricing_table_extra_options', 'qi_addons_for_elementor_premium_pricing_table_side_price_add_extra_options' );
}
