<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_rating_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_rating_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Rating_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_rating_shortcode', 9 );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Rating_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_rating_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_rating_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/rating' );
			$this->set_base( 'qi_addons_for_elementor_premium_rating' );
			$this->set_name( esc_html__( 'Rating', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds Rating element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/rating/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#rating' );
			$this->set_video( 'https://www.youtube.com/watch?v=zXs_DKXVMFc' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'standard',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'rating_value',
					'size_units'    => array( '%' ),
					'min'           => 0,
					'max'           => 100,
					'step'          => 1,
					'default_value' => array(
						'unit' => '%',
						'size' => '50',
					),
					'title'         => esc_html__( 'Rating', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'rating_marked_icon',
					'title'         => esc_html__( 'Marked Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-star',
						'library' => 'solid',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'rating_unmarked_icon',
					'title'         => esc_html__( 'Unmarked Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'far fa-star',
						'library' => 'regular',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'rating_alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'rating_alignment_vertical',
					'title'      => esc_html__( 'Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_flex', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-icon-holder' => 'align-items: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'split',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'rating_spacing',
					'title'      => esc_html__( 'Spacing', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( '%' ),
					'responsive' => true,
					'min'        => 0,
					'max'        => 100,
					'step'       => 1,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-icon > *, {{WRAPPER}} .qodef-e-icon > svg, {{WRAPPER}} .qodef-layout--split .qodef-m-icon-holder > *' => 'margin: 0 {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'rating_icon_size',
					'title'         => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px' ),
					'responsive'    => true,
					'min'           => 0,
					'max'           => 100,
					'step'          => 1,
					'default_value' => array(
						'unit' => 'px',
						'size' => '30',
					),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-e-icon > *, {{WRAPPER}} .qodef-e-icon > svg' => 'font-size: {{SIZE}}px; width: {{SIZE}}px;',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'rating_split_icon_size',
					'title'         => esc_html__( 'Icon Split Size', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px' ),
					'responsive'    => true,
					'min'           => 0,
					'max'           => 100,
					'step'          => 1,
					'default_value' => array(
						'unit' => 'px',
						'size' => '30',
					),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-layout--split .qodef-e-icon.qodef-e-icon-unmarked > *, {{WRAPPER}} .qodef-layout--split .qodef-e-icon.qodef-e-icon-unmarked > svg' => 'font-size: {{SIZE}}px; width: {{SIZE}}px;',
					),
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'split',
								'default_value' => 'standard',
							),
						),
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'rating_marked_color',
					'title'      => esc_html__( 'Marked Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-icon-marked' => 'color: {{VALUE}}; fill: {{VALUE}}; stroke: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'rating_unmarked_color',
					'title'      => esc_html__( 'Unmarked Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-icon-unmarked' => 'color: {{VALUE}}; fill: {{VALUE}}; stroke: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->map_extra_options();
		}

        public static function call_shortcode( $params ) {
            $html = qi_addons_for_elementor_framework_call_shortcode( 'qi_addons_for_elementor_premium_rating', $params );
            $html = str_replace( "\n", '', $html );

            return $html;
        }

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']       = $this->get_holder_classes( $atts );
			$atts['rating_marked_styles'] = $this->get_rating_marked_styles( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/rating', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-rating';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_rating_marked_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['rating_value']['size'] ) ) {
				$width = $atts['rating_value']['size'];

				$styles[] = 'width: calc(' . $width . '%)';
			}

			return $styles;
		}
	}
}
