<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_roatating_image_tiles_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_roatating_image_tiles_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Rotating_Image_Tiles_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_roatating_image_tiles_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Rotating_Image_Tiles_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/rotating-image-tiles' );
			$this->set_base( 'qi_addons_for_elementor_premium_rotating_image_tiles' );
			$this->set_name( esc_html__( 'Rotating Image Tiles', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds image tiles', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/rotating-image-tiles/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#rotating_image_tiles' );
			$this->set_video( 'https://youtu.be/evX0qUTdQ8Q' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'images',
					'title'      => esc_html__( 'Images', 'qi-addons-for-elementor-premium' ),
					'multiple'   => 'yes',
					'description'=> esc_html__( 'the required number of images is 4', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'width',
					'title'      => esc_html__( 'Holder Width/Height (px)', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'default_value' => array(
						'unit' => 'px',
						'size' => 500
					),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 2000,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-rotating-image-tiles' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; --qodef-image-tiles-size: {{SIZE}}{{UNIT}} !important;',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'rotation_delay',
					'title'      => esc_html__( 'Rotation Delay', 'qi-addons-for-elementor-premium' ),
					'description'=> esc_html__( 'default value is 2500 (ms)', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'   => 'select',
					'name'         => 'tiles_number',
					'title'        => esc_html__( 'Number of Tiles', 'qi-addons-for-elementor-premium' ),
					'options'      => array(
						'4'		=> esc_html__('Four', 'qi-addons-for-elementor-premium'),
						'9'		=> esc_html__('Nine', 'qi-addons-for-elementor-premium'),
						'16'		=> esc_html__('Sixteen', 'qi-addons-for-elementor-premium'),
					),
					'default_value' => '4',
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'tiles',
					'title'         => esc_html__( 'Tiles', 'qi-addons-for-elementor-premium' ),
					'items'         => array(
						array(
							'field_type'   => 'checkbox',
							'name'         => 'tile_visibility',
							'title'        => esc_html__( 'Show Tile', 'qi-addons-for-elementor-premium' ),
							'default_value' => 'yes',
						),
						array(
							'field_type'   => 'select',
							'name'         => 'tile_image_1_shape',
							'title'        => esc_html__( 'Image 1 Shape Position', 'qi-addons-for-elementor-premium' ),
							'options'      => array(
								'none'		    => esc_html__('None', 'qi-addons-for-elementor-premium'),
								'top-left'		=> esc_html__('Top Left', 'qi-addons-for-elementor-premium'),
								'top-right'		=> esc_html__('Top Right', 'qi-addons-for-elementor-premium'),
								'bottom-left'	=> esc_html__('Bottom Left', 'qi-addons-for-elementor-premium'),
								'bottom-right'	=> esc_html__('Bottom Right', 'qi-addons-for-elementor-premium'),
							),
							'default_value' => 'none',
							'dependency' => array(
								'show' => array(
									'tile_visibility' => array(
										'values'        => array( 'yes' ),
										'default_value' => 'yes',
									),
								),
							),
						),
						array(
							'field_type'   => 'select',
							'name'         => 'tile_image_2_shape',
							'title'        => esc_html__( 'Image 2 Shape Position', 'qi-addons-for-elementor-premium' ),
							'options'      => array(
								'none'		    => esc_html__('None', 'qi-addons-for-elementor-premium'),
								'top-left'		=> esc_html__('Top Left', 'qi-addons-for-elementor-premium'),
								'top-right'		=> esc_html__('Top Right', 'qi-addons-for-elementor-premium'),
								'bottom-left'	=> esc_html__('Bottom Left', 'qi-addons-for-elementor-premium'),
								'bottom-right'	=> esc_html__('Bottom Right', 'qi-addons-for-elementor-premium'),
							),
							'default_value' => 'none',
							'dependency' => array(
								'show' => array(
									'tile_visibility' => array(
										'values'        => array( 'yes' ),
										'default_value' => 'yes',
									),
								),
							),
						),
						array(
							'field_type'   => 'select',
							'name'         => 'tile_image_3_shape',
							'title'        => esc_html__( 'Image 3 Shape Position', 'qi-addons-for-elementor-premium' ),
							'options'      => array(
								'none'		    => esc_html__('None', 'qi-addons-for-elementor-premium'),
								'top-left'		=> esc_html__('Top Left', 'qi-addons-for-elementor-premium'),
								'top-right'		=> esc_html__('Top Right', 'qi-addons-for-elementor-premium'),
								'bottom-left'	=> esc_html__('Bottom Left', 'qi-addons-for-elementor-premium'),
								'bottom-right'	=> esc_html__('Bottom Right', 'qi-addons-for-elementor-premium'),
							),
							'default_value' => 'none',
							'dependency' => array(
								'show' => array(
									'tile_visibility' => array(
										'values'        => array( 'yes' ),
										'default_value' => 'yes',
									),
								),
							),
						),
						array(
							'field_type'   => 'select',
							'name'         => 'tile_image_4_shape',
							'title'        => esc_html__( 'Image 4 Shape Position', 'qi-addons-for-elementor-premium' ),
							'options'      => array(
								'none'		    => esc_html__('None', 'qi-addons-for-elementor-premium'),
								'top-left'		=> esc_html__('Top Left', 'qi-addons-for-elementor-premium'),
								'top-right'		=> esc_html__('Top Right', 'qi-addons-for-elementor-premium'),
								'bottom-left'	=> esc_html__('Bottom Left', 'qi-addons-for-elementor-premium'),
								'bottom-right'	=> esc_html__('Bottom Right', 'qi-addons-for-elementor-premium'),
							),
							'default_value' => 'none',
							'dependency' => array(
								'show' => array(
									'tile_visibility' => array(
										'values'        => array( 'yes' ),
										'default_value' => 'yes',
									),
								),
							),
						),
					),
				)
			);
			
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['holder_data'] = $this->get_holder_data_attrs( $atts );
			$atts['images'] = ! empty( $atts['images'] ) ? explode(',', $atts['images'] ) : array();
			$atts['items']          = $this->parse_repeater_items( $atts['tiles'] );
			$atts['this_object']    = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/rotating-image-tiles', 'templates/content', '', $atts );
		}


		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-rotating-image-tiles';
			$holder_classes[] = 'qodef-qi-'.$atts['tiles_number'].'-tiles';

			return implode( ' ', $holder_classes );
		}
		
		private function get_holder_data_attrs( $atts ) {
			$data = array();
			
			if ( ! empty( $atts['rotation_delay'] ) ) {
				$data['data-interval'] = $atts['rotation_delay'];
			}
			
			return $data;
		}

	}
}
