<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_social_links_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_social_links_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Social_Links_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_social_links_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Social_Links_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_social_links_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_social_links_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/social-links' );
			$this->set_base( 'qi_addons_for_elementor_premium_social_links' );
			$this->set_name( esc_html__( 'Social Links', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays social links', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'SEO', 'qi-addons-for-elementor-premium' ) );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/social-links/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#social_links' );
			$this->set_video( 'https://www.youtube.com/watch?v=-EaAffY_nPU' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'textual',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'direction',
					'title'         => esc_html__( 'Direction', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'vertical'   => esc_html__( 'Vertical', 'qi-addons-for-elementor-premium' ),
						'horizontal' => esc_html__( 'Horizontal', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'vertical',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'rotate',
					'title'         => esc_html__( 'Rotate', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						''      => esc_html__( 'No', 'qi-addons-for-elementor-premium' ),
						'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => '',
					'dependency'    => array(
						'relation' => 'and',
						'show'     => array(
							'direction' => array(
								'values'        => 'horizontal',
								'default_value' => 'vertical',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'icon_items',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_icon' => array(
								'value'   => 'fab fa-facebook',
								'library' => 'fa-brands',
							),
						),
						array(
							'item_icon' => array(
								'value'   => 'fab fa-instagram',
								'library' => 'fa-brands',
							),
						),
						array(
							'item_icon' => array(
								'value'   => 'fab fa-twitter',
								'library' => 'fa-brands',
							),
						),
					),
					'items'         => array(
						array(
							'field_type' => 'icons',
							'name'       => 'item_icon',
							'title'      => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_text' => esc_html__( 'Facebook', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_text' => esc_html__( 'Instagram', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_text' => esc_html__( 'Twitter', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type' => 'text',
							'name'       => 'item_text',
							'title'      => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'label',
					'title'      => esc_html__( 'Label', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'links_padding',
					'title'      => esc_html__( 'Links Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vw' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links .qodef-m-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'direction' => array(
								'values'        => 'vertical',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links .qodef-m-content' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'spacing',
					'title'      => esc_html__( 'Links Spacing', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links .qodef-m-content a' => 'margin-bottom: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-social-links.qodef-direction--horizontal.qodef-layout--textual .qodef-m-items-holder' => 'gap: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'links_typography',
					'title'      => esc_html__( 'Links Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-social-links .qodef-m-content a',
					'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

            $this->set_option(
                array(
                    'field_type' => 'start_controls_tabs',
                    'name'       => 'textual_links_style_tabs',
                    'title'      => esc_html__( 'Text Link Start', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'start_controls_tab',
                    'name'       => 'textual_links_tab_normal',
                    'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'color',
                    'title'      => esc_html__( 'Links Color', 'qi-addons-for-elementor-premium' ),
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links .qodef-m-content a' => 'color: {{VALUE}};',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'textual_link_background_color',
                    'title'      => esc_html__( 'Links Background Color', 'qi-addons-for-elementor-premium' ),
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links .qodef-m-content a' => 'background-color: {{VALUE}};',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'end_controls_tab',
                    'name'       => 'textual_links_tab_normal_end',
                    'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'start_controls_tab',
                    'name'       => 'textual_links_tab_hover',
                    'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'hover_color',
                    'title'      => esc_html__( 'Links Hover Color', 'qi-addons-for-elementor-premium' ),
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links .qodef-m-content a:hover' => 'color: {{VALUE}};',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'textual_link_background_hover_color',
                    'title'      => esc_html__( 'Links Background Hover Color', 'qi-addons-for-elementor-premium' ),
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links .qodef-m-content a:hover' => 'background-color: {{VALUE}};',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'end_controls_tab',
                    'name'       => 'textual_links_tab_hover_end',
                    'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'end_controls_tabs',
                    'name'       => 'textual_links_style_tabs_end',
                    'title'      => esc_html__( 'Text Link Start', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'dimensions',
                    'name'       => 'textual_link_padding',
                    'title'      => esc_html__( 'Links Padding', 'qi-addons-for-elementor-premium' ),
                    'size_units' => array( 'px', '%' ),
                    'responsive' => true,
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links.qodef-layout--textual a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show'     => array(
                            'layout'     => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'divider',
                    'name'       => 'item_divider_style_border',
                    'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'slider',
                    'name'       => 'textual_link_border_width',
                    'title'      => esc_html__( 'Links Border Size', 'qi-addons-for-elementor-premium' ),
                    'size_units' => array( 'px', 'em', 'vw' ),
                    'range'      => array(
                        'px' => array(
                            'min' => 0,
                            'max' => 30,
                        ),
                    ),
                    'responsive' => true,
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links.qodef-layout--textual a' => 'border: {{SIZE}}{{UNIT}} solid;',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show'     => array(
                            'layout'     => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'textual_link_border_color',
                    'title'      => esc_html__( 'Links Border Color', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links.qodef-layout--textual a' => 'border-color: {{VALUE}};',
                    ),
                    'dependency' => array(
                        'show'     => array(
                            'layout'     => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'textual_link_hover_border_color',
                    'title'      => esc_html__( 'Links Hover Border Color', 'qi-addons-for-elementor-premium' ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links.qodef-layout--textual a:hover' => 'border-color: {{VALUE}};',
                    ),
                    'dependency' => array(
                        'show'     => array(
                            'layout'     => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'dimensions',
                    'name'       => 'textual_link_border_radius',
                    'title'      => esc_html__( 'Links Border Radius', 'qi-addons-for-elementor-premium' ),
                    'size_units' => array( 'px', '%' ),
                    'responsive' => true,
                    'selectors'  => array(
                        '{{WRAPPER}} .qodef-qi-social-links.qodef-layout--textual a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ),
                    'group'      => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
                    'dependency' => array(
                        'show'     => array(
                            'layout'     => array(
                                'values'        => 'textual',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'enable_links_underline_hover',
					'title'         => esc_html__( 'Enable Links Underline Hover', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'group'         => esc_html__( 'Text Link Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_boxed',
					'title'         => esc_html__( 'Icon Boxed', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', true ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'icon_style_tabs',
					'title'      => esc_html__( 'Icon Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'icon_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_background_color',
					'title'      => esc_html__( 'Icon Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_border_color',
					'title'      => esc_html__( 'Icon Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_stroke_color',
					'title'      => esc_html__( 'Icon Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_fill_color',
					'title'      => esc_html__( 'Icon Fill Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a svg' => 'fill: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'icon_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'icon_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_hover_color',
					'title'      => esc_html__( 'Icon Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a:hover' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_background_hover_color',
					'title'      => esc_html__( 'Icon Background Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a:hover' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_border_hover_color',
					'title'      => esc_html__( 'Icon Border Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a:hover' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_stroke_hover_color',
					'title'      => esc_html__( 'Icon Stroke Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a:hover svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_fill_hover_color',
					'title'      => esc_html__( 'Icon Fill Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a:hover svg' => 'fill: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'icon_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'icon_style_tabs_end',
					'title'      => esc_html__( 'Icon End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'icon_divider_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_box_size',
					'title'      => esc_html__( 'Icon Box Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_border_width',
					'title'      => esc_html__( 'Icon Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'icon_border_radius',
					'title'      => esc_html__( 'Icon Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'layout'     => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'icon_stroke_width',
					'title'         => esc_html__( 'Icon Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-qi-social-links a svg' => 'stroke-width: {{VALUE}};',
					),
					'default_value' => 1,
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'label_position',
					'title'         => esc_html__( 'Label Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left' => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'top'  => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'left',
					'group'         => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'relation' => 'and',
						'show'     => array(
							'direction' => array(
								'values'        => 'horizontal',
								'default_value' => 'vertical',
							),
							'rotate'    => array(
								'values'        => '',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_color',
					'title'      => esc_html__( 'Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links .qode-e-label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'hide' => array(
							'label' => array(
								'values'        => '',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'label_typography',
					'title'      => esc_html__( 'Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-social-links .qode-e-label',
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'hide' => array(
							'label' => array(
								'values'        => '',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'label_spacing',
					'title'      => esc_html__( 'Label Spacing', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-links.qodef-direction--horizontal .qode-e-label'                           => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-social-links.qodef-direction--horizontal.qodef-label-position--top .qode-e-label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-social-links.qodef-direction--vertical .qode-e-label'                             => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			if ( 'icon' === $atts['layout'] ) {
				$atts['items'] = $this->parse_repeater_items( $atts['icon_items'] );
			} else {
				$atts['items'] = $this->parse_repeater_items( $atts['children'] );
			}

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/social-links', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-social-links';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['direction'] ) ? 'qodef-direction--' . $atts['direction'] : '';
			$holder_classes[] = ! empty( $atts['rotate'] ) ? 'qodef-rotate--' . $atts['rotate'] : '';
			$holder_classes[] = ( 'yes' === $atts['icon_boxed'] ) ? 'qodef-icon-boxed' : '';
			$holder_classes[] = ! empty( $atts['label'] ) && '' !== $atts['label'] ? 'qodef-has-label' : '';
			$holder_classes[] = ! empty( $atts['label_position'] ) && '' !== $atts['label_position'] ? 'qodef-label-position--' . $atts['label_position'] : '';
			$holder_classes[] = ! empty( $atts['alignment'] ) && '' !== $atts['alignment'] ? 'qodef-alignment--' . $atts['alignment'] : '';
			$holder_classes[] = ( 'yes' === $atts['enable_links_underline_hover'] ) ? 'qodef--links-underline-hover' : '';

			return implode( ' ', $holder_classes );
		}
	}
}
