<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_social_share_buttons_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_social_share_buttons_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Social_Share_Buttons_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_social_share_buttons_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Social_Share_Buttons_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_social_share_buttons_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_social_share_buttons_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/social-share-buttons' );
			$this->set_base( 'qi_addons_for_elementor_premium_social_share_buttons' );
			$this->set_name( esc_html__( 'Social Share Buttons', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays social share networks', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'SEO', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/social-share-buttons/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#social_share_buttons' );
			$this->set_video( 'https://www.youtube.com/watch?v=4f4Ytk1t16c' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'list',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'type',
					'title'         => esc_html__( 'Type', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'icon'    => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
						'textual' => esc_html__( 'Textual', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'icon',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'network_name',
					'title'         => esc_html__( 'Network Name', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'full_name' => esc_html__( 'Full Name', 'qi-addons-for-elementor-premium' ),
						'shorten'   => esc_html__( 'Shorten', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'full_name',
					'dependency'    => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$social_networks = qi_addons_for_elementor_premium_social_networks_list();

			foreach ( $social_networks as $network => $params ) {

				$this->set_option(
					array(
						'field_type'    => 'checkbox',
						'name'          => 'enable_share_' . $network,
						'title'         => sprintf( esc_html__( 'Enable %s Share', 'qi-addons-for-elementor-premium' ), $params['label'] ),
						'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
						'default_value' => 'yes',
					)
				);

				$this->set_option(
					array(
						'field_type'    => 'icons',
						'name'          => 'icon_type_' . $network,
						'title'         => sprintf( esc_html__( '%s Icon', 'qi-addons-for-elementor-premium' ), $params['label'] ),
						'default_value' => array(
							'value'   => 'fab fa-' . $network,
							'library' => 'fa-brands',
						),
						'dependency'    => array(
							'relation' => 'and',
							'show'     => array(
								'type'                     => array(
									'values'        => 'icon',
									'default_value' => '',
								),
								'enable_share_' . $network => array(
									'values'        => 'yes',
									'default_value' => '',
								),
							),
						),
					)
				);

				if ( 'twitter' === $network ) {
					$this->set_option(
						array(
							'field_type'    => 'text',
							'name'          => 'twitter_via_text',
							'title'         => esc_html__( 'Twitter Via Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( '@QodeInteractive', 'qi-addons-for-elementor-premium' ),
							'dependency'    => array(
								'show' => array(
									'enable_share_twitter' => array(
										'values'        => 'yes',
										'default_value' => 'yes',
									),
								),
							),
						)
					);
				}
			}

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'dropdown_behavior',
					'title'         => esc_html__( 'Dropdown Hover Behavior', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'bottom' => esc_html__( 'Animate to Bottom', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Animate on Right', 'qi-addons-for-elementor-premium' ),
						'left'   => esc_html__( 'Animate on Left', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'bottom',
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'dropdown',
								'default_value' => 'list',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'label_type',
					'title'         => esc_html__( 'Label Type', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'text'           => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
						'text_with_icon' => esc_html__( 'Text with icon', 'qi-addons-for-elementor-premium' ),
						'icon'           => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'text',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'text_label',
					'title'         => esc_html__( 'Social Share Text Label', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Share', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'text', 'text_with_icon' ),
								'default_value' => 'text',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'icon_label',
					'title'         => esc_html__( 'Social Share Icon Label', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-share-alt',
						'library' => 'fa-solid',
					),
					'dependency'    => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'mobile_align',
					'title'         => esc_html__( 'Mobile Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'center',
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => array( 'list' ),
								'default_value' => 'dropdown',
							),
						),
						'hide' => array(
							'network_name' => array(
								'values'        => array( 'shorten' ),
								'default_value' => 'full_name',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_margin',
					'title'      => esc_html__( 'Button Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_boxed',
					'title'         => esc_html__( 'Icon Boxed', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', true ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'type' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons .qodef-m-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'icon_style_tabs',
					'title'      => esc_html__( 'Icon Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'icon_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons .qodef-m-icon'   => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-social-share-buttons .qodef-m-icon a' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_background_color',
					'title'      => esc_html__( 'Icon Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons .qodef-m-icon' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_border_color',
					'title'      => esc_html__( 'Icon Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons .qodef-m-icon' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_stroke_color',
					'title'      => esc_html__( 'Icon Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons .qodef-m-icon svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_type[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'icon_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'icon_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_hover_color',
					'title'      => esc_html__( 'Icon Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons li a:hover .qodef-m-icon' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_background_hover_color',
					'title'      => esc_html__( 'Icon Background Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons li a:hover .qodef-m-icon' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_border_hover_color',
					'title'      => esc_html__( 'Icon Border Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons li a:hover .qodef-m-icon' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_stroke_hover_color',
					'title'      => esc_html__( 'Icon Stroke Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-social-share-buttons li a:hover .qodef-m-icon svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_type[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'icon_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'icon_style_tabs_end',
					'title'      => esc_html__( 'Icon End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_box_size',
					'title'      => esc_html__( 'Icon Box Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_border_width',
					'title'      => esc_html__( 'Icon Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-icon' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'icon_border_radius',
					'title'      => esc_html__( 'Icon Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'type'       => array(
								'values'        => 'icon',
								'default_value' => '',
							),
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'icon_stroke_width',
					'title'         => esc_html__( 'Icon Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Network Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-icon svg' => 'stroke-width: {{VALUE}};',
					),
					'default_value' => 1,
					'dependency'    => array(
						'show' => array(
							'icon_type[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'network_text_color',
					'title'      => esc_html__( 'Network Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-social-network-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'network_text_hover_color',
					'title'      => esc_html__( 'Network Text Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-social-network-text:hover' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'network_text_typography',
					'title'      => esc_html__( 'Network Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-social-network-text',
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_underline_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'network_text_hover_underline',
					'title'      => esc_html__( 'Network Text Hover Underline', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'network_text_underline_color',
					'title'      => esc_html__( 'Underline Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network--hover-underline .qodef-social-network-text:after' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'network_text_hover_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'network_text_underline_width',
					'title'      => esc_html__( 'Underline Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network--hover-underline .qodef-social-network-text:after' => 'width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'network_text_hover_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'network_text_underline_offset',
					'title'      => esc_html__( 'Underline Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => - 20,
							'max' => 20,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network--hover-underline .qodef-social-network-text:after' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'network_text_hover_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'network_text_underline_thickness',
					'title'      => esc_html__( 'Underline Thickness', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network--hover-underline .qodef-social-network-text:after' => 'height: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'network_text_hover_underline' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_separator_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'network_text_separator',
					'title'         => esc_html__( 'Network Text Separator', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'relation' => 'and',
						'show'     => array(
							'layout' => array(
								'values'        => 'list',
								'default_value' => '',
							),
							'type'   => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'separator_color',
					'title'      => esc_html__( 'Separator Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network-text-separator ul li:after' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'network_text_separator' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'separator_width',
					'title'      => esc_html__( 'Separator Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network-text-separator ul li:after' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'network_text_separator' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'separator_height',
					'title'      => esc_html__( 'Separator Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-network-text-separator ul li:after' => 'height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'network_text_separator' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'separator_margin',
					'title'              => esc_html__( 'Separator Margin', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'right', 'left' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-network-text-separator ul li:after' => 'margin-right: {{RIGHT}}{{UNIT}}; margin-left: {{LEFT}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Network Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency'         => array(
						'show' => array(
							'network_text_separator' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'label_padding',
					'title'      => esc_html__( 'Label Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-holder'               => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-social-share-dropdown-opener' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'General Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'text_label_tag',
					'title'      => esc_html__( 'Text Label Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Text Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'text', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_label_color',
					'title'      => esc_html__( 'Text Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-social-share-label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'text', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_label_typography',
					'title'      => esc_html__( 'Text Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-social-share-label',
					'group'      => esc_html__( 'Text Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'text', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'text_label_padding',
					'title'      => esc_html__( 'Text Label Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-social-share-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Text Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'text', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'label_icon_position',
					'title'         => esc_html__( 'Icon Label Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'before_title' => esc_html__( 'Before Title', 'qi-addons-for-elementor-premium' ),
						'after_title'  => esc_html__( 'After Title', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'after_title',
					'group'         => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'label_type' => array(
								'values'        => 'text_with_icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'label_icon_boxed',
					'title'         => esc_html__( 'Icon Label Boxed', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', true ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'label_icon_size',
					'title'      => esc_html__( 'Icon Label Size', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_icon_color',
					'title'      => esc_html__( 'Icon Label Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'label_type' => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_icon_background_color',
					'title'      => esc_html__( 'Icon Label Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'label_type'       => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
							'label_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_icon_border_color',
					'title'      => esc_html__( 'Icon Label Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'label_type'       => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
							'label_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_icon_stroke_color',
					'title'      => esc_html__( 'Icon Label Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_type[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'label_icon_box_size',
					'title'      => esc_html__( 'Icon Label Box Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'label_type'       => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
							'label_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'label_icon_border_width',
					'title'      => esc_html__( 'Icon Label Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'label_type'       => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
							'label_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'label_icon_border_radius',
					'title'      => esc_html__( 'Icon Label Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'label_type'       => array(
								'values'        => array( 'icon', 'text_with_icon' ),
								'default_value' => '',
							),
							'label_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'label_icon_stroke_width',
					'title'         => esc_html__( 'Icon Label Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Icon Label Style', 'qi-addons-for-elementor-premium' ),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-label-icon' => 'stroke-width: {{VALUE}};',
					),
					'default_value' => 1,
					'dependency'    => array(
						'show' => array(
							'icon_label[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']  = $this->get_holder_classes( $atts );
			$atts['social_networks'] = $this->get_social_network_items( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/social-share-buttons', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-social-share-buttons';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['type'] ) ? 'qodef-type--' . $atts['type'] : '';
			$holder_classes[] = ! empty( $atts['layout'] ) && 'dropdown' === $atts['layout'] && ! empty( $atts['dropdown_behavior'] ) ? 'qodef-dropdown--' . $atts['dropdown_behavior'] : '';
			$holder_classes[] = ( 'yes' === $atts['icon_boxed'] ) ? 'qodef-icon-boxed' : '';
			$holder_classes[] = ( 'yes' === $atts['label_icon_boxed'] ) ? 'qodef-label-icon-boxed' : '';
			$holder_classes[] = ( 'before_title' === $atts['label_icon_position'] ) ? 'qodef-label-icon--before-title' : '';
			$holder_classes[] = ( 'full_name' === $atts['network_name'] && 'textual' === $atts['type'] ) ? 'qodef-network-name--full-name' : '';
			$holder_classes[] = ( 'yes' === $atts['network_text_separator'] ) ? 'qodef-network-text-separator' : '';
			$holder_classes[] = 'yes' === $atts['network_text_hover_underline'] ? 'qodef-network--hover-underline' : '';
			$holder_classes[] = ! empty( $atts['mobile_align'] ) ? 'qodef-mobile-align--' . $atts['mobile_align'] : '';

			return implode( ' ', $holder_classes );
		}

		/**
		 * Get Social Networks data to display
		 * @return array
		 */
		public function get_social_network_items( $atts ) {
			$networks             = array();
			$social_networks_list = qi_addons_for_elementor_premium_social_networks_list();

			foreach ( $social_networks_list as $network => $label ) {
				$network_enabled = 'yes' === $atts[ 'enable_share_' . $network ];

				if ( ! $network_enabled ) {
					unset( $social_networks_list[ $network ] );
				}
			}

			if ( ! empty( $social_networks_list ) ) {
				$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );

				foreach ( $social_networks_list as $network => $labels ) {
					$params['layout'] = $atts['layout'];
					$params['type']   = $atts['type'];
					$params['name']   = $network;

					$additional_params = '';
					if ( 'twitter' === $network && ! empty( $atts['twitter_via_text'] ) ) {
						$additional_params = $atts['twitter_via_text'];
					}

					$params['link'] = qi_addons_for_elementor_premium_get_social_network_share_link( $network, $image, $additional_params );

					if ( 'shorten' === $atts['network_name'] ) {
						$params['text'] = $labels['shorten'] . '.';
					} else {
						$params['text'] = $network;
					}

					// Get icons for not text layouts
					if ( 'text' !== $params['layout'] ) {
						$params['icon'] = $atts[ 'icon_type_' . $network ];
					}

					$networks[] = $params;
				}
			}

			return $networks;
		}
	}
}
