<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_social_networks_list' ) ) {
	/**
	 * Function that returns array of social networks.
	 *
	 * @return array - list of social networks
	 */
	function qi_addons_for_elementor_premium_social_networks_list() {
		$social_networks = array(
			'facebook'  => array(
				'label'   => esc_html__( 'Facebook', 'qi-addons-for-elementor-premium' ),
				'shorten' => esc_html__( 'fb', 'qi-addons-for-elementor-premium' ),
			),
			'twitter'   => array(
				'label'   => esc_html__( 'Twitter', 'qi-addons-for-elementor-premium' ),
				'shorten' => esc_html__( 'tw', 'qi-addons-for-elementor-premium' ),
			),
			'linkedin'  => array(
				'label'   => esc_html__( 'LinkedIn', 'qi-addons-for-elementor-premium' ),
				'shorten' => esc_html__( 'lnkd', 'qi-addons-for-elementor-premium' ),
			),
			'pinterest' => array(
				'label'   => esc_html__( 'Pinterest', 'qi-addons-for-elementor-premium' ),
				'shorten' => esc_html__( 'pin', 'qi-addons-for-elementor-premium' ),
			),
			'tumblr'    => array(
				'label'   => esc_html__( 'Tumblr', 'qi-addons-for-elementor-premium' ),
				'shorten' => esc_html__( 'tmb', 'qi-addons-for-elementor-premium' ),
			),
			'vk'        => array(
				'label'   => esc_html__( 'VK', 'qi-addons-for-elementor-premium' ),
				'shorten' => esc_html__( 'vk', 'qi-addons-for-elementor-premium' ),
			),
		);

		return apply_filters( 'qi_addons_for_elementor_premium_filter_social_networks_list', $social_networks );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_social_network_share_link' ) ) {
	/**
	 * Get share link for networks
	 *
	 * @param string $net
	 * @param array  $image
	 * @param array  $additional_params
	 *
	 * @return string
	 */
	function qi_addons_for_elementor_premium_get_social_network_share_link( $net, $image, $additional_params = '' ) {
		switch ( $net ) {
			case 'facebook':
				if ( wp_is_mobile() ) {
					$link = 'window.open(\'https://m.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '\');';
				} else {
					$link = 'window.open(\'https://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '\', \'sharer\', \'toolbar=0,status=0,width=620,height=280\');';
				}
				break;
            case 'twitter':
                $count_char             = is_ssl() ? 23 : 22;
                $twitter_via_option_val = $additional_params;
                $twitter_via            = '' !== $twitter_via_option_val ? esc_attr__( ' via ', 'qi-addons-for-elementor-premium' ) . esc_attr( $twitter_via_option_val ) : '';
                $link                   = 'window.open(\'https://twitter.com/intent/tweet?text=' . urlencode( qi_addons_for_elementor_premium_get_social_network_excerpt_max_charlength( $count_char ) . $twitter_via ) . get_permalink() . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');';
                break;
			case 'linkedin':
				$link = 'popUp=window.open(\'https://linkedin.com/shareArticle?mini=true&amp;url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;';
				break;
			case 'tumblr':
				$link = 'popUp=window.open(\'https://www.tumblr.com/share/link?url=' . urlencode( get_permalink() ) . '&amp;name=' . urlencode( get_the_title() ) . '&amp;description=' . urlencode( get_the_excerpt() ) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;';
				break;
			case 'pinterest':
				$media = ( $image ) ? '&amp;media=' . urlencode( $image[0] ) : '';
				$link  = 'popUp=window.open(\'https://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;description=' . urlencode( get_the_title() ) . $media . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;';
				break;
			case 'vk':
				$media = ( $image ) ? '&amp;image=' . urlencode( $image[0] ) : '';
				$link  = 'popUp=window.open(\'https://vkontakte.ru/share.php?url=' . urlencode( get_permalink() ) . '&amp;title=' . urlencode( get_the_title() ) . '&amp;description=' . urlencode( get_the_excerpt() ) . $media . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;';
				break;
			default:
				$link = '';
		}

		return apply_filters( 'qi_addons_for_elementor_premium_filter_social_network_share_link', $link, $net, $image );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_social_network_excerpt_max_charlength' ) ) {
	/**
	 * Function that return meta text for social network sharing
	 *
	 * @param int $charlength
	 *
	 * @return string
	 */
	function qi_addons_for_elementor_premium_get_social_network_excerpt_max_charlength( $charlength ) {

		$excerpt_text = get_the_excerpt();
		$excerpt      = esc_html( strip_shortcodes( $excerpt_text ) );
		$charlength   = 139 - $charlength;

		if ( mb_strlen( $excerpt ) > $charlength ) {
			$subex   = mb_substr( $excerpt, 0, $charlength );
			$exwords = explode( ' ', $subex );
			$excut   = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );

			if ( $excut < 0 ) {
				return mb_substr( $subex, 0, $excut );
			} else {
				return $subex;
			}
		} else {
			return $excerpt;
		}
	}
}
