<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_stacked_item_scroll_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_stacked_item_scroll_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Stacked_Item_Scroll_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_stacked_item_scroll_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Stacked_Item_Scroll_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_stacked_item_scroll_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/stacked-item-scroll' );
			$this->set_base( 'qi_addons_for_elementor_premium_stacked_item_scroll' );
			$this->set_name( esc_html__( 'Stacked Item Scroll', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays stacked item scroll', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/stacked-item-scroll/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#stacked_item_scroll' );
			$this->set_video( 'https://www.youtube.com/watch?v=O8-BnJs57C0' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
					'description'   => esc_html__( 'Please note that text, button and scroll note will not be visible in case page height is bigger than window height', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_tag',
					'title'         => esc_html__( 'Text Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h1',
					'group'         => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-main-holder > .qodef-m-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-main-holder > .qodef-m-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_text_gradient',
					'title'      => esc_html__( 'Enable Text Gradient', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'gradient_colors',
					'title'         => esc_html__( 'Gradient', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'enable_text_gradient' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'default_value' => array(
						array(
							'gradient_color'   => '#00ffff',
							'color_percentage' => 0,
						),
						array(
							'gradient_color'   => '#ffffff',
							'color_percentage' => 100,
						),
					),
					'items'         => array(
						array(
							'field_type' => 'color',
							'name'       => 'gradient_color',
							'title'      => esc_html__( 'Color', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'color_percentage',
							'title'      => esc_html__( 'Percent', 'qi-addons-for-elementor-premium' ),
							'range'      => array(
								'px' => array(
									'min' => 0,
									'max' => 100,
								),
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'gradient_degree',
					'title'         => esc_html__( 'Gradient Degree', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px' ),
					'range'         => array(
						'px' => array(
							'min' => - 180,
							'max' => 180,
						),
					),
					'default_value' => array(
						'size' => 180,
						'unit' => 'px',
					),
					'group'         => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'enable_text_gradient' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_width',
					'title'      => esc_html__( 'Text Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 100,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-main-holder' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_bottom',
					'title'      => esc_html__( 'Text Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-main-holder > .qodef-m-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image' => $placeholder,
							'item_text'  => esc_html__( 'Item Text 1', 'qi-addons-for-elementor-premium' ),
							'item_link'  => array(),
						),
						array(
							'item_image' => $placeholder,
							'item_text'  => esc_html__( 'Item Text 2', 'qi-addons-for-elementor-premium' ),
							'item_link'  => array(),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_text',
							'title'         => esc_html__( 'Item Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Item Text', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'         => 'dimensions',
							'name'               => 'item_center_offset',
							'title'              => esc_html__( 'Item Offset from Center', 'qi-addons-for-elementor-premium' ),
							'allowed_dimensions' => array( 'top', 'left' ),
							'size_units'         => array( 'px', '%', 'em' ),
							'responsive'         => true,
							'selectors'          => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-e-item' => 'top: calc(50% + {{TOP}}{{UNIT}}); left: calc(50% + {{LEFT}}{{UNIT}});',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'cursor_text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-hover-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Cursor Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'cursor_text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-hover-text',
					'group'      => esc_html__( 'Cursor Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'cursor_background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-hover-text' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Cursor Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'cursor_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-hover-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Cursor Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'scroll_color',
					'title'      => esc_html__( 'Note Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-scroll-note' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Scroll Note Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'scroll_typography',
					'title'      => esc_html__( 'Note Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-scroll-note',
					'group'      => esc_html__( 'Scroll Note Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'scroll_line_left_position',
					'title'      => esc_html__( 'Left Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => -200,
							'max' => 200,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-scroll-note' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Scroll Note Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'scroll_line_length',
					'title'      => esc_html__( 'Line Length', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-scroll-note .qodef-m-line' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Scroll Note Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'scroll_line_thickness',
					'title'      => esc_html__( 'Line Thickness', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-scroll-note .qodef-m-line' => 'height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Scroll Note Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'scroll_line_space_around',
					'title'      => esc_html__( 'Line Space Around', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-scroll-note .qodef-m-line' => 'margin: 0 {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Scroll Note Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['button_params']  = $this->generate_button_params( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['text_style']     = $this->get_text_gradient_style( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/stacked-item-scroll', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-stacked-item-scroll';
			$holder_classes[] = ( 'yes' === $atts['enable_text_gradient'] ) ? 'qodef-text--gradient' : '';

			return implode( ' ', $holder_classes );
		}

		private function generate_button_params( $atts ) {
			$params = array();

			if ( ! empty( $atts['button_text'] ) || ! empty( $atts['button_icon']['value'] ) ) {
				$params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
			}

			return $params;
		}

		private function get_text_gradient_style( $atts ) {
			$style = '';

			$gradient_colors = $this->parse_repeater_items( $atts['gradient_colors'] );

			if ( 'yes' === $atts['enable_text_gradient'] && count( $gradient_colors ) ) {
				$style = 'background: linear-gradient(' . $atts['gradient_degree']['size'] . 'deg';

				foreach ( $gradient_colors as $color ) {
					$style .= ',' . $color['gradient_color'] . ' ' . $color['color_percentage']['size'] . '%';
				}

				$style .= ')';
			}

			return $style;
		}
	}
}
