<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_text_gradient_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_text_gradient_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Text_Gradient_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_text_gradient_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Text_Gradient_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_text_gradient_extra_options', array(), $this ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/text-gradient' );
			$this->set_base( 'qi_addons_for_elementor_premium_text_gradient' );
			$this->set_name( esc_html__( 'Text Gradient', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays text gradient with provided parameters', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Typography', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/text-gradient/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#text_gradient' );
			$this->set_video( 'https://www.youtube.com/watch?v=O6fDMDbR9go' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text(),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-text-gradient',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-text-gradient' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'gradient_animation',
					'title'         => esc_html__( 'Enable Gradient Animation', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'color',
					'name'          => 'animation_color',
					'title'         => esc_html__( 'Gradient Animation Color', 'qi-addons-for-elementor-premium' ),
					'default_value' => '#8f51fe',
					'dependency'    => array(
						'show' => array(
							'gradient_animation' => array(
								'values'        => 'yes',
								'default_value' => 'yes',
							),
						),
					),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-text' => '--qodef-qi-gradient-animation-color: {{VALUE}};',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'gradient_colors',
					'title'         => esc_html__( 'Colors', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_color'       => '#2A8080',
							'color_percentage' => array(
								'size' => 0,
								'unit' => 'px',
							),
						),
						array(
							'item_color'       => '#ffffff',
							'color_percentage' => array(
								'size' => 85,
								'unit' => 'px',
							),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'color',
							'name'          => 'item_color',
							'title'         => esc_html__( 'Color', 'qi-addons-for-elementor-premium' ),
							'default_value' => '#00ff00',
						),
						array(
							'field_type'    => 'slider',
							'name'          => 'color_percentage',
							'title'         => esc_html__( 'Percent', 'qi-addons-for-elementor-premium' ),
							'range'         => array(
								'px' => array(
									'min' => 0,
									'max' => 100,
								),
							),
							'default_value' => array(
								'size' => 100,
								'unit' => 'px',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'gradient_degree',
					'title'         => esc_html__( 'Gradient Degree', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px' ),
					'range'         => array(
						'px' => array(
							'min' => - 180,
							'max' => 180,
						),
					),
					'default_value' => array(
						'size' => 90,
						'unit' => 'px',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();
		}

		public function render( $options, $content = null ) {

			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['gradient_style'] = $this->get_gradient_style( $atts );
			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/text-gradient', 'templates/text-gradient', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-text-gradient';
			$holder_classes[] = 'yes' === $atts['gradient_animation'] ? 'qodef-qi--animated' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_gradient_style( $params ) {
			$style = '';

			$gradient_colors = $this->parse_repeater_items( $params['gradient_colors'] );

			if ( count( $gradient_colors ) ) {
				$style = 'background: linear-gradient(' . $params['gradient_degree']['size'] . 'deg';

				foreach ( $gradient_colors as $color ) {
					$style .= ',' . $color['item_color'] . ' ' . $color['color_percentage']['size'] . '%';
				}

				$style .= ')';
			}

			return $style;
		}
	}
}
