<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_textual_projects_showcase_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_textual_projects_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Textual_Projects_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_textual_projects_showcase_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Textual_Projects_Showcase_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_textual_projects_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/textual-projects-showcase' );
			$this->set_base( 'qi_addons_for_elementor_premium_textual_projects_showcase' );
			$this->set_name( esc_html__( 'Textual Project Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays textual projects showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/textual-project-showcase/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#textual_project_showcase' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items',
					'title'      => esc_html__( 'Space Between Items', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text'  => 'margin: 0 {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-image' => 'margin: 0 {{SIZE}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_appear',
					'title'         => esc_html__( 'Appear Animation', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'image_hover',
					'title'         => esc_html__( 'Image Hover', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						''             => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
						'change-image' => esc_html__( 'Change Image', 'qi-addons-for-elementor-premium' ),
						'zoom'         => esc_html__( 'Zoom Image', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'change-image',
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Item Elements', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_type' => 'text',
							'item_text' => esc_html__( 'Item', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type' => 'text',
							'item_text' => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type'  => 'image',
							'item_image' => $placeholder,
						),
						array(
							'item_type' => 'text',
							'item_text' => esc_html__( 'Example', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'select',
							'name'          => 'item_type',
							'title'         => esc_html__( 'Type', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'image' => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
								'text'  => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'image',
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => array( 'image' ),
										'default_value' => 'image',
									),
								),
							),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image_hover',
							'title'         => esc_html__( 'Hover Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => array( 'image' ),
										'default_value' => 'image',
									),
								),
							),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
							'dependency' => array(
								'show' => array(
									'item_type' => array(
										'values'        => array( 'image' ),
										'default_value' => 'image',
									),
								),
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_image_width',
							'title'      => esc_html__( 'Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em', 'vw' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-e-image' => 'width: {{SIZE}}{{UNIT}};',
							),
							'dependency' => array(
								'show' => array(
									'item_type' => array(
										'values'        => array( 'image' ),
										'default_value' => 'image',
									),
								),
							),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => '',
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => array( 'text' ),
										'default_value' => '',
									),
								),
							),
						),
						array(
							'field_type' => 'typography',
							'name'       => 'text_typography',
							'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
							'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}}.qodef-e-text',
							'dependency' => array(
								'show' => array(
									'item_type' => array(
										'values'        => array( 'text' ),
										'default_value' => '',
									),
								),
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'highlight',
							'title'         => esc_html__( 'Highlight Text', 'qi-addons-for-elementor-premium' ),
							'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
							'default_value' => 'no',
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => 'text',
										'default_value' => '',
									),
								),
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'highlight_svg_type',
							'title'         => esc_html__( 'Highlight SVG Type', 'qi-addons-for-elementor-premium' ),
							'media_types'   => array( 'svg' ),
							'description'   => esc_html__( 'Choose predefined SVG image to use as highlight', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'ripped-lines'    => esc_html__( 'Ripped Lines', 'qi-addons-for-elementor-premium' ),
								'drawn-underline' => esc_html__( 'Drawn Underline', 'qi-addons-for-elementor-premium' ),
								'rectangle'       => esc_html__( 'Rectangle', 'qi-addons-for-elementor-premium' ),
								'line'            => esc_html__( 'Line', 'qi-addons-for-elementor-premium' ),
								'custom'          => esc_html__( 'Custom', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'ripped-lines',
							'dependency'    => array(
								'show' => array(
									'highlight' => array(
										'values'        => 'yes',
										'default_value' => 'no',
									),
								),
							),
						),
						array(
							'field_type'  => 'image',
							'name'        => 'highlight_svg',
							'title'       => esc_html__( 'SVG Image', 'qi-addons-for-elementor-premium' ),
							'media_types' => array( 'svg' ),
							'description' => esc_html__( 'Upload SVG image if you want to override default svg highlight', 'qi-addons-for-elementor-premium' ),
							'dependency'  => array(
								'show' => array(
									'highlight_svg_type' => array(
										'values'        => 'custom',
										'default_value' => 'no',
									),
								),
							),
						),
						array(
							'field_type'         => 'dimensions',
							'name'               => 'highlight_svg_position',
							'title'              => esc_html__( 'SVG Position', 'qi-addons-for-elementor-premium' ),
							'allowed_dimensions' => array( 'top', 'left' ),
							'size_units'         => array( 'px' ),
							'responsive'         => true,
							'selectors'          => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} svg' => 'top: {{TOP}}{{UNIT}} !important; left: {{LEFT}}{{UNIT}} !important;',
							),
							'dependency'         => array(
								'show' => array(
									'highlight' => array(
										'values'        => 'yes',
										'default_value' => '',
									),
								),
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_alignment',
							'title'         => esc_html__( 'Item Alignment', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'flex-start' => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
								'center'     => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
								'flex-end'   => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'center',
							'selectors'     => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}' => 'align-self: {{VALUE}};',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'text_tag',
					'title'      => esc_html__( 'Text Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'highlight_text_color',
					'title'      => esc_html__( 'Highlight Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text.qodef--highlight' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/textual-projects-showcase', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes   = $this->init_holder_classes();
			$holder_classes[] = ! empty( $atts['enable_appear'] ) && 'yes' == $atts['enable_appear'] ? 'qodef-qi--has-appear' : '';
			$holder_classes[] = 'qodef-textual-projects-showcase';
			$holder_classes[] = ! empty( $atts['image_hover'] ) ? 'qodef-image-hover--' . esc_attr( $atts['image_hover'] ) : '';

			return implode( ' ', $holder_classes );
		}

		public function get_highlight_svg_url( $item ) {
			if ( ! empty( $item['highlight_svg'] ) ) {
				$highlight_svg_url          = esc_url( wp_get_attachment_url( $item['highlight_svg'] ) );
				$item['highlight_svg_icon'] = array(
					'library' => 'svg',
					'value'   => array(
						'url' => $highlight_svg_url,
						'id'  => $item['highlight_svg'],
					),
				);

				return $item['highlight_svg_icon'];
			}

			return '';
		}
	}
}
