<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_timeline_layouts_variation_vertical_side_date' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_filter_timeline_layouts_variation_vertical_side_date( $variations ) {
		$variations['vertical-side-date'] = esc_html__( 'Vertical Side Date Premium', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_filter_timeline_layouts', 'qi_addons_for_elementor_premium_filter_timeline_layouts_variation_vertical_side_date', 15 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_timeline_layouts_type_vertical_side_date' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param string $type
	 * @param string $layout
	 *
	 * @return string
	 */
	function qi_addons_for_elementor_premium_filter_timeline_layouts_type_vertical_side_date( $layouts ) {

		$layouts['vertical-side-date'] = 'vertical';

		return $layouts;
	}

	add_filter( 'qi_addons_for_elementor_filter_timeline_layouts_type', 'qi_addons_for_elementor_premium_filter_timeline_layouts_type_vertical_side_date', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_filter_timeline_reverse_padding_vertical_side_date' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param string $type
	 * @param string $layout
	 *
	 * @return string
	 */
	function qi_addons_for_elementor_premium_filter_timeline_reverse_padding_vertical_side_date( $layouts ) {

		$layouts[] = 'vertical-side-date';

		return $layouts;
	}

	add_filter( 'qi_addons_for_elementor_filter_timeline_reverse_padding_layouts', 'qi_addons_for_elementor_premium_filter_timeline_reverse_padding_vertical_side_date', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_timeline_vertical_side_date_render' ) ) {
	function qi_addons_for_elementor_premium_timeline_vertical_side_date_render( $template, $atts ) {
		if ( 'vertical-side-date' === $atts['layout'] ) {
			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/timeline', 'variations/' . $atts['layout'] . '/layouts/' . $atts['layout'], '', $atts );
		} else {
			return $template;
		}
	}

	add_filter( 'qi_addons_for_elementor_filter_timeline_render_template', 'qi_addons_for_elementor_premium_timeline_vertical_side_date_render', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_timeline_vertical_side_date_options' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_timeline_vertical_side_date_options( $options ) {
		$vertical_side_date = array();

		$side_width = array(
			'field_type' => 'slider',
			'name'       => 'vertical_side_date_side_width',
			'title'      => esc_html__( 'Sides Width', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'vw' ),
			'range'      => array(
				'px' => array(
					'min' => 100,
					'max' => 500,
				),
				'%'  => array(
					'min' => 1,
					'max' => 50,
				),
				'vw' => array(
					'min' => 1,
					'max' => 50,
				),
			),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-side-holder' => 'width: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-content-holder' => 'width: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'vertical-side-date',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
		);

		$image_margin_bottom = array(
			'field_type' => 'slider',
			'name'       => 'vertical_side_date_image_margin_bottom',
			'title'      => esc_html__( 'Image Margin Bottom', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'vertical-side-date',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$space_from_center = array(
			'field_type' => 'slider',
			'name'       => 'vertical_side_date_space_from_center',
			'title'      => esc_html__( 'Space From Center', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'range'      => array(
				'px' => array(
					'min' => 0,
					'max' => 500,
				),
				'%'  => array(
					'min' => 1,
					'max' => 40,
				),
			),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-side-holder'                                => 'padding: 0 {{SIZE}}{{UNIT}} 0 0;',
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-content-holder'                             => 'padding: 0 0 0 {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-item.qodef-reverse .qodef-e-side-holder'    => 'padding: 0 0 0 {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .qodef-timeline-layout--vertical-side-date .qodef-e-item.qodef-reverse .qodef-e-content-holder' => 'padding: 0 {{SIZE}}{{UNIT}} 0 0;',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'vertical-side-date',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$vertical_side_date[] = $side_width;
		$vertical_side_date[] = $image_margin_bottom;
		$vertical_side_date[] = $space_from_center;

		return array_merge( $options, $vertical_side_date );
	}

	add_filter( 'qi_addons_for_elementor_filter_timeline_extra_options', 'qi_addons_for_elementor_premium_add_timeline_vertical_side_date_options' );
}
