<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_typeforms_form_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_typeforms_form_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Typeforms_Form_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_typeforms_form_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Typeforms_Form_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_typeforms_form_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_typeforms_form_extra_options', array(), $this ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/typeforms-form' );
			$this->set_base( 'qi_addons_for_elementor_premium_typeforms_form' );
			$this->set_name( esc_html__( 'Typeforms Form', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds Typeforms Form element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Form Style', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/typeforms-form/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#typeforms_form' );
			$this->set_necessary_styles(
				array(
					'typeform-css' => array(
						'registered' => false,
						'url'        => '//embed.typeform.com/next/css/widget.css',
						'dependency' => array(),
					),
				)
			);
			$this->set_scripts(
				array(
					'typeform-js' => array(
						'registered' => true,
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$options_map = qi_addons_for_elementor_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => $this->get_layouts(),
					'default_value' => 'standard',
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'code',
					'name'       => 'html',
					'title'      => esc_html__( 'HTML', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'typeform-js' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/typeforms-form', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-typeforms-form';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
