<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_vertical_circled_slider_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_vertical_circled_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Vertical_Circled_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_vertical_circled_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Vertical_Circled_Slider_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_vertical_circled_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/vertical-circled-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_vertical_circled_slider' );
			$this->set_name( esc_html__( 'Vertical Circled Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays vertical circled slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/vertical-circled-slider/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#vertical_circled_slider' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_slider_options(
				array(
					'group'          => 'Slider Settings',
					'exclude_option' => array( 'centered', 'images_proportion' ),
					'include_option' => array( 'vertical' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'enable_mouse_scroll',
					'title'         => esc_html__( 'Enable Mouse Scroll', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => 'Slider Settings',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'slider_reverse_columns',
					'title'         => esc_html__( 'Reverse Columns', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'slider_circle_image',
					'title'         => esc_html__( 'Circle Images', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'enable_button',
					'title'         => esc_html__( 'Enable Button', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h1',
					'group'         => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-title',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_content_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-text-content' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_content_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-text-content',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'item_padding',
					'title'              => esc_html__( 'Text Padding', 'qi-addons-for-elementor-premium' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'allowed_dimensions' => array( 'left', 'right' ),
					'selectors'          => array(
						'{{WRAPPER}} .qodef-vertical-circled-slider-text' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'scroll_label_color',
					'title'      => esc_html__( 'Scroll Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-scroll-label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'scroll_label_typography',
					'title'      => esc_html__( 'Scroll Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-scroll-label',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'see_all_label_color',
					'title'      => esc_html__( 'See All Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-see-all-label a' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'see_all_label_hover_color',
					'title'      => esc_html__( 'See All Label Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-see-all-label a:hover' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'see_all_label_typography',
					'title'      => esc_html__( 'See All Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-see-all-label',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image' => $placeholder,
							'item_link'  => array(),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'textarea',
							'name'          => 'text',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'textarea',
							'name'          => 'text_content',
							'title'         => esc_html__( 'Content', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text(),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Button Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'scroll_label',
					'title'         => esc_html__( 'Scroll Label', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_attr__( 'Scroll away', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'see_all_label',
					'title'         => esc_html__( 'See All', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_attr__( 'See All', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'link',
					'name'       => 'see_all_link',
					'title'      => esc_html__( 'See All Link', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_animation',
					'title'         => esc_html__( 'Text Animation', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'fade-in'     => esc_html__( 'Fade In', 'qi-addons-for-elementor-premium' ),
						'from-right'  => esc_html__( 'From Right', 'qi-addons-for-elementor-premium' ),
						'fade-in-raw' => esc_html__( 'Fade In Raw', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'fade-in',
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_premium_premium_button',
					'exclude'           => array( 'custom_class', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_margin_top',
					'title'      => esc_html__( 'Button Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-button' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'enable_button' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'scroll_label_left_position',
					'title'      => esc_html__( 'Scroll Label Left Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-scroll-label' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'see_all_label_left_position',
					'title'      => esc_html__( 'See All Left Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-see-all-label' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'see_all_label_bottom_position',
					'title'      => esc_html__( 'See All Bottom Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-see-all-label' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['centered_slides'] = 'yes';

			$atts['unique']              = rand( 0, 999 );
			$atts['main_holder_classes'] = $this->get_main_holder_classes( $atts );
			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['text_holder_classes'] = $this->get_text_holder_classes( $atts );
			$atts['item_classes']        = $this->get_item_classes( $atts );
			$atts['items']               = $this->parse_repeater_items( $atts['children'] );
			$sliderScroll                = ! empty( $atts['enable_mouse_scroll'] ) && 'yes' === $atts['enable_mouse_scroll'] ? true : false;
			$atts['slider_attr']         = $this->get_slider_data( $atts, array( 'sliderScroll' => $sliderScroll ) );
			$atts['text_slider_attr']    = $this->get_text_slider_data( $atts );
			$atts['button_params']       = $this->generate_button_params( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/vertical-circled-slider', 'templates/content', '', $atts );
		}

		private function get_main_holder_classes( $atts ) {
			$main_holder_classes = $this->init_holder_classes();

			$main_holder_classes[] = 'qodef-qi-vertical-circled-slider';
			$main_holder_classes[] = ! empty( $atts['slider_reverse_columns'] ) && 'yes' === $atts['slider_reverse_columns'] ? 'qodef--slider-reverse-columns' : '';
			$main_holder_classes[] = ! empty( $atts['slider_circle_image'] ) && 'yes' === $atts['slider_circle_image'] ? 'qodef--slider-circle-image' : '';
			$main_holder_classes[] = ! empty( $atts['text_animation'] ) ? 'qodef-qi--text-animation-' . $atts['text_animation'] : '';
			$main_holder_classes[] = ! empty( $atts['slider_loop'] ) ? 'qodef-qi-slider-loop--' . $atts['slider_loop'] : '';

			return implode( ' ', $main_holder_classes );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes[] = '';

			$slider_classes = $this->get_slider_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $slider_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_text_holder_classes( $atts ) {
			$holder_classes[] = 'qodef-vertical-circled-slider-text';

			$slider_classes = $this->get_slider_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $slider_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$slider_item_classes = $this->get_slider_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $slider_item_classes );

			return implode( ' ', $item_classes );
		}

		private function get_text_slider_data( $atts ) {

			$atts['direction']            = 'vertical';
			$atts['unique']               = '';
			$atts['columns']              = 1;
			$atts['columns_1440']         = 1;
			$atts['columns_1366']         = 1;
			$atts['columns_1024']         = 1;
			$atts['columns_768']          = 1;
			$atts['columns_680']          = 1;
			$atts['columns_480']          = 1;
			$atts['space']['size']        = 0;
			$atts['space_tablet']['size'] = 0;
			$atts['space_mobile']['size'] = 0;
			$atts['centered_slides']      = 'no';
			$atts['slider_navigation']    = 'no';
			$atts['slider_pagination']    = 'no';
			$atts['partial_columns']      = 'no';
			$atts['effect']               = 'fade';
			$sliderScroll                 = ! empty( $atts['enable_mouse_scroll'] ) && 'yes' === $atts['enable_mouse_scroll'] ? true : false;

			return $this->get_slider_data( $atts, array( 'sliderScroll' => $sliderScroll ) );
		}

		private function generate_button_params( $atts ) {

			if ( 'yes' === $atts['enable_button'] ) {
				$atts['button_link'] = array(
					'url'               => '',
					'is_external'       => '',
					'nofollow'          => '',
					'custom_attributes' => '',
				);

				return $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_premium_premium_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
			}

			return array();
		}
	}
}
