<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_vertical_project_reel_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_vertical_project_reel_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Vertical_Project_Reel_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_vertical_project_reel_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Vertical_Project_Reel_Shortcode extends QiAddonsForElementor_List_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_vertical_project_reel_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/vertical-project-reel' );
			$this->set_base( 'qi_addons_for_elementor_premium_vertical_project_reel' );
			$this->set_name( esc_html__( 'Vertical Project Reel', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays project in vertical reel scrolling', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/vertical-project-reel/' );
			$this->set_video( 'https://youtu.be/tWezD7G8w9Q' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#vertical_project_reel' );
			$this->set_scripts(
				array(
					'gsap' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'note',
					'name'       => 'warning',
					'title'      => esc_html__( 'Please note that this shortcode can be used only as a standalone shortcode on a page', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image'       => $placeholder,
							'item_title'       => esc_html__( 'Item Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'    => esc_html__( 'Item Subtitle 1', 'qi-addons-for-elementor-premium' ),
							'item_button_text' => esc_html__( 'See More 1', 'qi-addons-for-elementor-premium' ),
							'item_link'        => array(),
						),
						array(
							'item_image'       => $placeholder,
							'item_title'       => esc_html__( 'Item Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'    => esc_html__( 'Item Subtitle 2', 'qi-addons-for-elementor-premium' ),
							'item_button_text' => esc_html__( 'See More 2', 'qi-addons-for-elementor-premium' ),
							'item_link'        => array(),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Item Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_subtitle',
							'title'         => esc_html__( 'Item Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'subtitle' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_button_text',
							'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'See more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_animation',
					'title'         => esc_html__( 'Text Animation', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'fade-in'     => esc_html__( 'Fade In', 'qi-addons-for-elementor-premium' ),
						'from-right'  => esc_html__( 'From Right', 'qi-addons-for-elementor-premium' ),
						'fade-in-raw' => esc_html__( 'Fade In Raw', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'fade-in',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h1',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left-inner .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-vertical-project-reel-left-inner .qodef-e-title',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left-inner .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-vertical-project-reel-left-inner .qodef-e-subtitle',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_left_offset',
					'title'      => esc_html__( 'Text Left Offset', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left article' => 'padding-left: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left article .qodef-e-item-inner .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left article .qodef-e-item-inner .qodef-e-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_content_and_image',
					'title'      => esc_html__( 'Space Between Content and Image Responsive', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left article .qodef-e-image' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items_responsive',
					'title'      => esc_html__( 'Space Between Items Responsive', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-vertical-project-reel-left article' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/vertical-project-reel', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-vertical-project-reel';
			$holder_classes[] = ! empty( $atts['text_animation'] ) ? 'qodef-qi--text-animation-' . $atts['text_animation'] : '';

			return implode( ' ', $holder_classes );
		}

	}
}
