<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_vertical_timeline_shortcode' ) ) {
	/**
	 * Function that add vertical timeline for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_vertical_timeline_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Vertical_Timeline_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_vertical_timeline_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Vertical_Timeline_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/vertical-timeline' );
			$this->set_base( 'qi_addons_for_elementor_premium_vertical_timeline' );
			$this->set_name( esc_html__( 'Vertical Timeline', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays vertical timeline', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/vertical-timeline/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#vertical_timeline' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'date',
					'title'         => esc_html__( 'Date', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'July 20, 2021',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'hours' => '1980',
							'text'  => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'hours' => '1983',
							'text'  => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'hours',
							'title'         => esc_html__( 'Hours', 'qi-addons-for-elementor-premium' ),
							'dynamic'       => false,
							'default_value' => '13h - 14h',
						),
						array(
							'field_type'    => 'html',
							'name'          => 'content',
							'title'         => esc_html__( 'Content', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'field_type' => 'image',
							'name'       => 'image',
							'title'      => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'space_between_items',
					'title'         => esc_html__( 'Space Between Items', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px', 'em' ),
					'range'         => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive'    => true,
					'selectors'     => array(
						'{{WRAPPER}} .qodef-e-item:not(:last-child)' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					),
					'default_value' => array(
						'unit' => 'px',
						'size' => '30',
					),
					'group'         => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'item_side_padding',
					'title'      => esc_html__( 'Item Side Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-content' => 'padding: 0 0 0 {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'date_margin',
					'title'      => esc_html__( 'Date Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-date-holder-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'date_padding',
					'title'      => esc_html__( 'Date Padding', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'date_width',
					'title'      => esc_html__( 'Date Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-date' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'date_color',
					'title'      => esc_html__( 'Date Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-date' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'date_typography',
					'title'      => esc_html__( 'Date Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-date',
					'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'date_background_color',
					'title'      => esc_html__( 'Date Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-date-holder-inner' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'content_position',
					'title'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'below' => esc_html__( 'Content Below Hours', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Content Right from Hours', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'below',
					'group'         => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_margin_top',
					'title'      => esc_html__( 'Content Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'content_position' => array(
								'values'        => 'below',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_padding_bottom',
					'title'      => esc_html__( 'Content Padding Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'content_position' => array(
								'values'        => 'below',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'content_margin',
					'title'      => esc_html__( 'Content Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'content_position' => array(
								'values'        => 'right',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'content_color',
					'title'      => esc_html__( 'Content Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'content_typography',
					'title'      => esc_html__( 'Content Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-content',
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'hours_color',
					'title'      => esc_html__( 'Hours Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-hours' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Hours Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'hours_typography',
					'title'      => esc_html__( 'Hours Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-hours',
					'group'      => esc_html__( 'Hours Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'hours_minimal_width',
					'title'      => esc_html__( 'Hours Minimal Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-hours' => 'min-width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'content_position' => array(
								'values'        => 'right',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Hours Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'image_proportion',
					'default_value' => 'full',
					'title'         => esc_html__( 'Image Proportions', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'list_image_dimension', false, array( 'custom' ) ),
					'group'         => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'image_margin_bottom',
					'title'      => esc_html__( 'Image Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'line_start_position',
					'title'         => esc_html__( 'Line Start Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'date'       => esc_html__( 'Date Label', 'qi-addons-for-elementor-premium' ),
						'first-item' => esc_html__( 'First Item', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'date',
					'group'         => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'line_color',
					'title'      => esc_html__( 'Line Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-line' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'line_thickness',
					'title'      => esc_html__( 'Line Thickness', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-line-holder'  => 'width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-point-holder' => 'left: calc({{SIZE}}{{UNIT}} /2);',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'point_type',
					'title'      => esc_html__( 'Point Type', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'standard' => esc_html__( 'Standard', 'qi-addons-for-elementor-premium' ),
						'line'     => esc_html__( 'Line', 'qi-addons-for-elementor-premium' ),
						'icon'     => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_size',
					'title'      => esc_html__( 'Point Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point-holder' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'standard',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_width',
					'title'      => esc_html__( 'Point Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point-holder' => 'width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'line',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_height',
					'title'      => esc_html__( 'Point Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point-holder' => 'height: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'line',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_position',
					'title'      => esc_html__( 'Point Horizontal Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point-holder' => 'margin-left: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'line',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_vertical_position',
					'title'      => esc_html__( 'Point Vertical Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point-holder' => 'top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'point_color',
					'title'      => esc_html__( 'Point Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => array( 'standard', 'line' ),
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'point_border_radius',
					'title'      => esc_html__( 'Point Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'standard',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'icons',
					'name'       => 'icon_type',
					'title'      => esc_html__( 'Icon Type', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point .qodef-e-icon-holder' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-point .qodef-e-icon-holder' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/vertical-timeline', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-vertical-timeline';
			$holder_classes[] = ! empty( $atts['content_position'] ) ? 'qodef-content-position--' . $atts['content_position'] : '';
			$holder_classes[] = ! empty( $atts['point_type'] ) ? 'qodef-point--' . $atts['point_type'] : '';
			$holder_classes[] = ! empty( $atts['line_start_position'] ) && $atts['line_start_position'] === 'first-item' ? 'qodef-line-start--' . $atts['line_start_position'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
