<?php

class StalCoreElementorClientsList extends \Elementor\Widget_Base{

	public $object;

	function __construct(array $data = [], $args = null) {
		$this->set_object();
		parent::__construct($data, $args);

	}

	public function set_object(){
			$this->object = qode_framework_get_framework_root()->get_shortcodes()->get_shortcode('stal_core_clients_list');
	}

	public function get_name() {
		return $this->object->get_base();
	}

	public function get_title() {
		return $this->object->get_name();
	}

	public function get_script_depends() {
		return QodeFrameworkElementor_Translator::get_instance()->set_scripts( $this->object);
	}

	public function get_icon() {
		return 'qodef-custom-elementor-icon ' .  str_replace('_', '-', $this->get_name());
	}

	public function get_categories() {
		return [ 'qode' ];
	}

	protected function register_controls() {

		QodeFrameworkElementor_Translator::get_instance()->create_controls( $this, $this->object);

	}

	protected function render(){

		QodeFrameworkElementor_Translator::get_instance()->create_render( $this->object, $this->get_settings_for_display());
	}

}

$is_disabled = stal_core_performance_get_option_value( 'clients', 'stal_core_performance_post_type_' );
if(! $is_disabled) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StalCoreElementorClientsList() );
}