<?php

if ( ! function_exists( 'stal_core_add_vertical_split_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function stal_core_add_vertical_split_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'StalVerticalSplitSliderShortcode';

		return $shortcodes;
	}

	add_filter( 'stal_core_filter_register_shortcodes', 'stal_core_add_vertical_split_slider_shortcode' );
}

if ( class_exists( 'StalCoreShortcode' ) ) {
	class StalVerticalSplitSliderShortcode extends StalCoreShortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( STAL_CORE_SHORTCODES_URL_PATH . '/vertical-split-slider' );
			$this->set_base( 'stal_vertical_split_slider' );
			$this->set_name( esc_html__( 'Vertical Split Slider', 'stal-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds vertical split slider holder', 'stal-core' ) );
			$this->set_category( esc_html__( 'Stal Core', 'stal-core' ) );
			$this->set_scripts(
				array(
					'jquery-effects-core' => array(
						'registered'	=> true
					),
					'multiscroll' => array(
						'registered'	=> false,
						'url'			=> STAL_CORE_SHORTCODES_URL_PATH . '/vertical-split-slider/assets/js/plugins/jquery.multiscroll.min.js',
						'dependency'	=> array( 'jquery', 'jquery-effects-core' )
					)
				)
			);
			$this->set_necessary_styles(
				array(
					'multiscroll' => array(
						'registered'	=> false,
						'url'			=> STAL_CORE_SHORTCODES_URL_PATH . '/vertical-split-slider/assets/css/plugins/jquery.multiscroll.css'
					)
				)
			);

			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'stal-core' ),
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'disable_breakpoint',
				'title'         => esc_html__( 'Disable on smaller screens', 'stal-core' ),
				'options'       => array(
					'1024' => esc_html__( 'Below 1024px', 'stal-core' ),
					'768'  => esc_html__( 'Below 768px', 'stal-core' ),
				),
				'default_value' => '1024'
			) );

			$slide_items_array = array(
				array(
					'field_type' => 'select',
					'name'       => 'slide_header_style',
					'title'      => esc_html__( 'Header Style', 'stal-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'stal-core' ),
						'light' => esc_html__( 'Light', 'stal-core' ),
						'dark'  => esc_html__( 'Dark', 'stal-core' ),
					)
				),
				array(
					'field_type' => 'select',
					'name'       => 'slide_bullets_style',
					'title'      => esc_html__( 'Bullets Style', 'stal-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'stal-core' ),
						'light' => esc_html__( 'Light', 'stal-core' ),
						'dark'  => esc_html__( 'Dark', 'stal-core' ),
					)
				),
				array(
					'field_type' => 'select',
					'name'       => 'slide_layout',
					'title'      => esc_html__( 'Slide Layout', 'stal-core' ),
					'options'    => array(
						'image-left'  => esc_html__( 'Image On Left', 'stal-core' ),
						'image-right' => esc_html__( 'Image On Right', 'stal-core' )
					),
				),
				array(
					'field_type' => 'image',
					'name'       => 'slide_image',
					'title'      => esc_html__( 'Image', 'stal-core' )
				)
			);

			if ( qode_framework_is_installed( 'elementor' ) ) {
				$elementor_sections = stal_core_generate_elementor_templates_control( $this );
				if(!empty($elementor_sections)){
					$slide_items_array[] = $elementor_sections;
				}
			}

			$this->set_option( array(
				'field_type' => 'repeater',
				'name'       => 'children',
				'title'      => esc_html__( 'Slide Items', 'stal-core' ),
				'items'      => $slide_items_array
			) );
		}
		
		public function load_assets() {
			wp_enqueue_script( 'jquery-effects-core' );
			wp_enqueue_script( 'multiscroll' );
			wp_enqueue_style( 'multiscroll' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts                   = $this->get_atts();
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['this_object']    = $this;
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return stal_core_get_template_part( 'shortcodes/vertical-split-slider', 'templates/vertical-split-slider', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-vertical-split-slider qodef-m';
			$holder_classes[] = ! empty ( $atts['disable_breakpoint'] ) ? 'qodef-disable-below--' . $atts['disable_breakpoint'] : '';

			return implode( ' ', $holder_classes );
		}

		public function get_slide_image_styles( $slide_atts ) {
			$styles = array();

			$styles[] = ! empty( $slide_atts['slide_image'] ) ? 'background-image: url(' . wp_get_attachment_url( $slide_atts['slide_image'] ) . ')' : '';

			return $styles;
		}

		public function get_slide_data( $slide_atts ) {
			$data = array();

			$data['data-header-skin'] = ! empty( $slide_atts['slide_header_style'] ) ? $slide_atts['slide_header_style'] : '';
			$data['data-bullets-skin'] = ! empty( $slide_atts['slide_bullets_style'] ) ? $slide_atts['slide_bullets_style'] : '';

			return $data;
		}
	}
}