<?php

if ( ! function_exists( 'stal_is_page_title_enabled' ) ) {
	/**
	 * Function that check is module enabled
	 */
	function stal_is_page_title_enabled() {
		return apply_filters( 'stal_filter_enable_page_title', true );
	}
}

if ( ! function_exists( 'stal_load_page_title' ) ) {
	/**
	 * Function which loads page template module
	 */
	function stal_load_page_title() {
		
		if ( stal_is_page_title_enabled() ) {
			// Include title template
			echo apply_filters( 'stal_filter_title_template', stal_get_template_part( 'title', 'templates/title' ) );
		}
	}
	
	add_action( 'stal_action_page_title_template', 'stal_load_page_title' );
}

if ( ! function_exists( 'stal_get_page_title_classes' ) ) {
	/**
	 * Function that return classes for page title area
	 *
	 * @return string
	 */
	function stal_get_page_title_classes() {
		$classes = apply_filters( 'stal_filter_page_title_classes', array() );
		
		return implode( ' ', $classes );
	}
}

if ( ! function_exists( 'stal_get_page_title_text' ) ) {
	/**
	 * Function that returns current page title text
	 */
	function stal_get_page_title_text() {
		$title = get_the_title(stal_get_page_id());
		
		if ( ( is_home() && is_front_page() ) ) {
			$title = get_option( 'blogname' );
		} elseif ( is_singular( 'post' ) ) {
			$title = esc_html__( 'Blog', 'stal' );
		} elseif ( is_tag() ) {
			$title = single_term_title( '', false ) . esc_html__( ' Tag', 'stal' );
		} elseif ( is_date() ) {
			$title = get_the_time( 'F Y' );
		} elseif ( is_author() ) {
			$title = esc_html__( 'Author: ', 'stal' ) . get_the_author();
		} elseif ( is_category() ) {
			$title = single_cat_title( '', false );
		} elseif ( is_archive() ) {
			$title = esc_html__( 'Archive', 'stal' );
		} elseif ( is_search() ) {
			$title = esc_html__( 'Search results for: ', 'stal' ) . get_search_query();
		} elseif ( is_404() ) {
			$title = esc_html__( '404 - Page not found', 'stal' );
		}
		
		return apply_filters( 'stal_filter_page_title_text', $title );
	}
}